/******************************************************************
*
*	CyberLink for C
*
*	Copyright (C) Satoshi Konno 2005
*
*       Copyright (C) 2006 Nokia Corporation. All rights reserved.
*
*       This is licensed under BSD-style license with patent exclusion,
*       see file COPYING.
*
*	File: cicon.c
*
*	Revision:
*
*	02/14/05
*		- first revision
*
******************************************************************/

#include <cybergarage/upnp/cicon.h>
#include <cybergarage/util/clog.h>

/****************************************
* cg_upnp_icon_new
****************************************/

CgUpnpIcon *cg_upnp_icon_new()
{
	cg_log_debug_l4("Entering...\n");

	CgUpnpIcon *dev = (CgUpnpIcon *)malloc(sizeof(CgUpnpIcon));

	if  ( NULL != dev )
		cg_list_node_init((CgList *)dev);

	return dev;

	cg_log_debug_l4("Leaving...\n");
}

/****************************************
* cg_upnp_icon_delete
****************************************/

void cg_upnp_icon_delete(CgUpnpIcon *dev)
{
	cg_log_debug_l4("Entering...\n");

	cg_list_remove((CgList *)dev);
	free(dev);

	cg_log_debug_l4("Leaving...\n");
}
