/*
 * UPnP Browser for Maemo
 *
 * resource_selection.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
 
#ifndef RESOURCE_SELECTION_H
#define RESOURCE_SELECTION_H

#include <gtk/gtk.h>
#include <cybergarage/util/clist.h>
#include <cybergarage/util/cstring.h>

enum
{
	RESOURCEMODEL_COLUMN_NAME = 0,
	RESOURCEMODEL_COLUMNS
};

typedef struct _ResourceSelectionDialog
{
	GtkWidget* dialog;
	GtkWidget* vbox;

	GtkWidget* dialog_action_area;
	GtkWidget* ok_button;
	GtkWidget* cancel_button;

	GtkWidget* view;
	GtkListStore* model;
	GtkWidget* scrolled_window;

} ResourceSelectionDialog;

/**
 * Create a dialog
 */
ResourceSelectionDialog* resource_selection_dialog_new();

/**
 * Create the view & model components
 */
void resource_selection_dialog_create_view_model(ResourceSelectionDialog* dialog);

/**
 * Destroy a dialog
 */
void resource_selection_dialog_delete(ResourceSelectionDialog* dialog);

/**
 * Update the dialog
 *
 * @param dialog The dialog
 * @param resString A string containing resources
 */
void resource_selection_dialog_update(ResourceSelectionDialog* dialog,
				      gchar* resString);

/**
 * Get the selected text from the model
 *
 * @param dialog The dialog
 * @param selection A newly-allocated string containing the selected text
 */
gboolean resource_selection_dialog_get_selection(ResourceSelectionDialog* dialog,
						 gchar** selection);
						 
/**
 * Shortcut function that displays the resource selection dialog.
 *
 * @param resString A string containing resources
 * @param selection The URI that the user has selected
 * @return TRUE if the user pressed OK; otherwise FALSE
 */
gboolean resource_selection_dialog_run(gchar* resString, gchar** selection);

#endif
