/*
 * UPnP Browser for Maemo
 *
 * playlist.c
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
 
#include "playlist.h"

/****************************************************************************
 * Playlist
 ****************************************************************************/

Playlist* playlist_new()
{
	Playlist* list = (Playlist*) malloc(sizeof(Playlist));
	if (list)
	{
		cg_list_header_init((CgList*) list);
	}

	return list;
}

void playlist_delete(Playlist* list)
{
	if (list)
	{
		playlist_clear(list);
		free(list);
	}
}

/****************************************************************************
 * Playlist Entry
 ****************************************************************************/

PlaylistEntry* playlist_entry_new()
{
	PlaylistEntry* entry = (PlaylistEntry*) malloc(sizeof(PlaylistEntry));
	if (entry)
	{
		cg_list_node_init((CgList*) entry);

		entry->trackName = cg_string_new();
		entry->trackURI = cg_string_new();
		entry->rendererUDN = cg_string_new();
		entry->serverUDN = cg_string_new();
		
		if (entry->trackName == NULL || entry->trackURI == NULL ||
		    entry->rendererUDN == NULL || entry->serverUDN == NULL)
		{
			playlist_entry_delete(entry);
			entry = NULL;
		}
	}

	return entry;

}

void playlist_entry_delete(PlaylistEntry* entry)
{
	if (entry)
	{
		cg_list_remove((CgList*) entry);

		cg_string_delete(entry->trackURI);
		cg_string_delete(entry->trackName);
		cg_string_delete(entry->rendererUDN);
		cg_string_delete(entry->serverUDN);

		free(entry);
	}
}
