/*
 * UPnP Browser for Maemo
 *
 * media_control.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
 
#ifndef MEDIA_CONTROL_H
#define MEDIA_CONTROL_H

/**
 * Callback to start playing the selected media
 *
 * @param folder_model Folder model
 * @param folder_iter Selected item in folder model
 * @param renderer_iter Selected item in renderer combo
 */
gboolean play_media();

/**
 * Play selected media in a local renderer
 *
 * @param uri The URI of the media
 * @param node_class UPnP node class of the selected media
 */

gboolean play_local_media(gchar* uri, gchar* node_class);

/**
 * Stop playing a media (remote or local)
 *
 */
void stop_media();

/**
 * Stop playing local media
 *
 */
void stop_local_media();

/**
 * Pause playing media (remote or local)
 *
 */
void pause_media();

/**
 * Pause playing media locally
 *
 */
void pause_local_media();

/**
 * Skip to next media
 */
void next_media();

/**
 * Skip to next local media
 */
void next_local_media();

/**
 * Skip to previous media
 */
void previous_media();

/**
 * Skip to previous local media
 */
void previous_local_media();


/**
 * Un/Mute media
 *
 */
void mute_media();

/**
 * Un/Mute local media
 *
 */
void mute_local_media();

/**
 * Decrease volume
 *
 */
void decrease_volume();

/**
 * Decrease local volume
 *
 */
void decrease_local_volume();

/**
 * Increase volume
 *
 */
void increase_volume();

/**
 * Increase local volume
 *
 */
void increase_local_volume();

/**
 * Seek the current media to the given position
 *
 * @param seekto Seek to this position (seconds)
 */
void seek_media(long seekto);

/**
 * Seek the current local media to the given position
 *
 * @param seekto Seek to this position (seconds)
 */
void seek_local_media(long seekto);

#endif
