/*
 * Copyright © 2004-2006 Nokia Corporation
 *
 * Permission to use, copy, modify, distribute and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the authors and/or copyright holders
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  The authors and
 * copyright holders make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without any express
 * or implied warranty.
 *
 * THE AUTHORS AND COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Daniel Stone <daniel.stone@nokia.com>
 */

#ifndef _OMAP_H_
#define _OMAP_H_

#ifdef HAVE_KDRIVE_CONFIG_H
#include <kdrive-config.h>
#endif

#include <stdint.h>
#include <fbdev.h>
#include <scrnintstr.h>
#include "kdrive.h"
#include "cursor.h"
#include "cursorstr.h"
#include "picturestr.h"
#ifdef XV
#include "kxv.h"
#endif


#define ENTER() DebugF("Enter %s\n", __FUNCTION__)
#define LEAVE() DebugF("Leave %s\n", __FUNCTION__)

#define wrap(priv, real, mem, func) {\
    priv->mem = real->mem; \
    real->mem = func; \
}

#define unwrap(priv, real, mem) {\
    real->mem = priv->mem; \
}


/* Minimum time between framebuffer updates, in ms. */
#define OMAP_UPDATE_TIME 50

/* DSP control. */
#define OMAP_DSP_FILENAME                       "/dev/dspctl/ctl"
#define OMAP_DSP_IOCTL_FBEN			53
#define OMAP_DSP_IOCTL_FBDIS			54

/* this will go away when xv moves to the plane interface. */
#define OMAP_NUM_PLANES 4


typedef struct _omapCardInfo OmapCardInfo;
typedef struct _omapScreenInfo OmapScreenInfo;
typedef struct _omapPlaneInfo OmapPlaneInfo;
typedef struct _omapPortPriv OmapPortPriv;

#define getOmapCardInfo(kd)      ((OmapCardInfo *) ((kd)->card->driver))
#define omapCardInfo(kd)         OmapCardInfo *omapc = getOmapCardInfo(kd)

#define getOmapScreenInfo(kd)    ((OmapScreenInfo *) ((kd)->screen->driver))
#define omapScreenInfo(kd)       OmapScreenInfo *omaps = getOmapScreenInfo(kd)

#define getOmapPortPriv(omaps, n) ((OmapPortPriv *) (omaps)->pAdaptor->pPortPrivates[n])
#define omapPortPriv(omaps, n)   OmapPortPriv *pPortPriv = getOmapPortPriv(omaps, n)

/* Software downscaling. */
typedef void (*omapScalePackedFunc)(KdScreenInfo *screen,
                                    OmapPortPriv *pPortPriv, CARD8 *src,
                                    CARD8 *dst, int randr, int srcPitch,
                                    int dstPitch, int srcW, int srcH,
                                    int top, int left, int h, int w,
                                    int dstW, int dstH);
typedef void (*omapScalePlanarFunc)(KdScreenInfo *screen,
                                    OmapPortPriv *pPortPriv, CARD8 *src,
                                    CARD8 *dst, int randr, int srcPitch,
                                    int srcPitch2, int dstPitch, int srcW,
                                    int srcH, int height, int top, int left,
                                    int h, int w, int id, int dstW, int dstH);

typedef enum omapPlaneType {
    OMAP_PLANE_DISPC_GFX,
    OMAP_PLANE_DISPC_VID,
    OMAP_PLANE_EXT_VID,
} OmapPlaneType;

struct _omapPlaneInfo {
    int id;

    OmapPlaneType type;

    char *filename;
    int fd;
    CARD32 *fb, fbsize;
    int pitch, bpp;

    int maxWidth, maxHeight;

    /* is this plane currently being used? */
    int active;

#ifdef XV
    OmapPortPriv *pPortPriv;
#endif

    struct _omapPlaneInfo *next;
};

struct _omapCardInfo {
    OmapPlaneInfo *planes;
    FbdevPriv fbdev;
};

struct _omapScreenInfo {
    FbdevScrPriv fbdev;
    OmapCardInfo *omapc;
    KdScreenInfo *screen;

    /* fb updating */
    BoxRec dirtyArea;
    DamagePtr pDamage;
    PixmapPtr pScreenPixmap;

    /* enable pixel doubling for updates to GFX */
    int pixelDoubled;
    /* should we watch the colourkey for dispc<->hailstorm vid migrations?
     * NULL if no, else pointer to the plane we should watch as a migration
     * candidate. */
    OmapPlaneInfo *watchColourKey;

    /* a vtec sticker on a hyundai */
    int updates;

    /* timer gets disabled after 500ms of inactivity. */
    int emptyUpdates, timerActive;

#ifdef XV
    /* video hilarity. */
    int numOverlayPorts;
    KdVideoAdaptorPtr pAdaptor;
#endif
};

struct _omapPortPriv {
    /* general overlay information */
    RegionRec clip;
    DrawablePtr pDrawable;
    CARD32 colorKey;
    OmapScreenInfo *omaps;

#if 0
    /* plane currently in use, if any */
    OmapPlaneInfo *plane;
#endif

    /* current frame information */
    int src_w, src_h;
    int dst_x, dst_y, dst_w, dst_h;
    Bool hscale, vscale;
    /* fourcc id, unrelated to plane number */
    int id;
    /* the format as omapfb sees it. */
    int format;

    /* downscaling algorithm */
    enum {
        OMAP_DOWNSCALING_NONE,
        OMAP_DOWNSCALING_POINT_SAMPLE,
        OMAP_DOWNSCALING_BILINEAR,
    } downscaling;

    /* copy and downscale a packed image */
    omapScalePackedFunc scalePacked;
    omapScalePlanarFunc scalePlanar;

    /* do we need to set the overlay up again? */
    Bool dirty;

    /* purple neons on the undercarriage */
    int frames;
    int frames_since;

    /* has the user selected vsync? and is the port capable? */
    enum {
        OMAP_VSYNC_NONE,
        OMAP_VSYNC_TEAR,
        OMAP_VSYNC_FORCE,
    } vsync;
    int vsyncCapable;

    /* these will go when we start using the plane interface. */
    CARD8 *overlay;
    CARD32 size;
    int pitch, bpp;
    int fd, plane;
    char *fileName;
    int active;
};


Bool omapDrawInit(ScreenPtr pScreen);
void omapDrawEnable(ScreenPtr pScreen);
void omapDrawDisable(ScreenPtr pScreen);
void omapDrawFini(ScreenPtr pScreen);

Bool omapCreateDrawResources(ScreenPtr pScreen);
void omapRemoveDrawResources(ScreenPtr pScreen);

#ifdef XV
Bool omapVideoInit(ScreenPtr pScreen);
void omapVideoFini(ScreenPtr pScreen);
void omapVideoStop(KdScreenInfo *screen, pointer data, Bool exit); 
#else
_X_INLINE Bool omapVideoInit(ScreenPtr pScreen) { return TRUE; }
_X_INLINE void omapVideoFini(ScreenPtr pScreen) { }
#endif

extern KdKeyboardDriver omapKeyboardDriver;
extern KdCardFuncs omapFuncs;

#endif /* _OMAP_H_ */
