/*
 * Copyright (c) 2003 Nokia
 * Author: tsavola@movial.fi
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef TYPES_H
#define TYPES_H

#include <stdint.h>
#include <sys/types.h>
#include <netinet/in.h>

typedef unsigned int bool_t;

#ifndef TRUE
# define TRUE  ((bool_t) 1)
#endif

#ifndef FALSE
# define FALSE ((bool_t) 0)
#endif

#if __BYTE_ORDER == __BIG_ENDIAN
# define htonll(n)  (n)
# define ntohll(n)  (n)
#elif __BYTE_ORDER == __LITTLE_ENDIAN
# define htonll(n)  ((((uint64_t) htonl(n)) << 32LL) | htonl((n) >> 32LL))
# define ntohll(n)  ((((uint64_t) ntohl(n)) << 32LL) | ntohl((n) >> 32LL))
#endif

#endif
