/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <config.h>
#include <stdio.h>
#include <string.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ob-backup-info.h"

static char *
get_absolute_path (const char *relative_path)
{
	char *current_dir;
	char *absolute_path;
	
	current_dir = g_get_current_dir ();
	absolute_path = g_build_filename (current_dir, relative_path, NULL);
	g_free (current_dir);

	return absolute_path;
}

static void
test_backup_info (void)
{
	char         *absolute_path;
	char         *uri_string;
	GnomeVFSURI  *uri;
	GList        *list, *l;
	int           len, i;
	ObBackupInfo *info;
	gboolean      correct;
	const char   *backups[] = { "backup3", "backup1", "backup2" };

	absolute_path = get_absolute_path (INFO_TESTDIR);
	uri_string = g_strconcat ("file://", absolute_path, NULL);
	g_free (absolute_path);
	
	uri = gnome_vfs_uri_new (uri_string);
	g_free (uri_string);

	list = ob_backup_info_list_get (uri);

	len = g_list_length (list);
	g_print ("Checking backups, found %d: ", len);
	if (len == 3) {
		g_print ("OK\n");
	} else {
		g_error ("Failed\n");
	}

	g_print ("Found backups:\n");

	correct = TRUE;
	
	for (l = list, i = 0; l; l = l->next, i++) {
		info = l->data;
		
		g_print (" %s\n", ob_backup_info_get_name (info));
		
		if (strcmp (ob_backup_info_get_name (info), backups[i]) != 0) {
			correct = FALSE;
			break;
		}
	}

	g_print ("Names matched: ");
	if (correct) {
		g_print ("OK\n");
	} else {
		g_error ("Failed.\n");
	}
	
	ob_backup_info_list_free (list);

	gnome_vfs_uri_unref (uri);
}

int
main (int argc, char **argv)
{
	gnome_vfs_init ();
	
	test_backup_info ();
	
	return 0;
}

