/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <config.h>
#include <string.h>
#include <stdarg.h>

#ifdef TRACING_ENABLED
#include <osso-log.h>
#endif

#include "ob-log.h"

/* For errors that cause exit or loss of important data. */
void
ob_log_critical (const char *message, ...)
{
#if defined(STDERR_LOGGING_ENABLED) || defined(TRACING_ENABLED)
	char    *str;
	va_list  args;
	
	va_start (args, message);
	str = g_strdup_vprintf (message, args);
	va_end (args);

#ifdef TRACING_ENABLED
	ULOG_CRIT (str);
#endif

#ifdef STDERR_LOGGING_ENABLED
	g_printerr ("osso-backup critical: %s\n", str);
#endif

	g_free (str);
#endif
}

/* For errors that cause an important operation to fail. */
void
ob_log_error (const char *message, ...)
{
#if defined(STDERR_LOGGING_ENABLED) || defined(TRACING_ENABLED)
	char    *str;
	va_list  args;
	
	va_start (args, message);
	str = g_strdup_vprintf (message, args);
	va_end (args);

#ifdef TRACING_ENABLED
	ULOG_ERR (str);
#endif

#ifdef STDERR_LOGGING_ENABLED
	g_printerr ("osso-backup error: %s\n", str);
#endif

	g_free (str);
#endif
}

/* For exceptional situations and minor errors that do not necessarily lead to
 * failure.
 */
void
ob_log_warning (const char *message, ...)
{
#if defined(STDERR_LOGGING_ENABLED) || defined(TRACING_ENABLED)
	char    *str;
	va_list  args;
	
	va_start (args, message);
	str = g_strdup_vprintf (message, args);
	va_end (args);

#ifdef TRACING_ENABLED
	ULOG_WARN (str);
#endif

#ifdef STDERR_LOGGING_ENABLED
	g_printerr ("osso-backup warning: %s\n", str);
#endif

	g_free (str);
#endif
}

/* For significant happenings (starting/stopping programs etc). */
void
ob_log_info (const char *message, ...)
{
#if defined(STDERR_LOGGING_ENABLED) || defined(TRACING_ENABLED)
	char    *str;
	va_list  args;
	
	va_start (args, message);
	str = g_strdup_vprintf (message, args);
	va_end (args);

#ifdef TRACING_ENABLED
	ULOG_INFO (str);
#endif

#ifdef STDERR_LOGGING_ENABLED
	g_printerr ("osso-backup info: %s\n", str);
#endif

	g_free (str);
#endif
}

void
ob_log_start (void)
{
#ifdef TRACING_ENABLED
	ULOG_OPEN (PACKAGE_STRING);
#endif

	ob_log_info ("Started");
}

void
ob_log_stop (void)
{
	ob_log_info ("Stopped");

#ifdef TRACING_ENABLED
	LOG_CLOSE ();
#endif
}

