/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef GSF_OUTPUT_CRYPT_H_
#define GSF_OUTPUT_CRYPT_H_

#include <gsf/gsf-output.h>

G_BEGIN_DECLS

#define GSF_OUTPUT_CRYPT_TYPE        (gsf_output_crypt_get_type ())
#define GSF_OUTPUT_CRYPT(o)          (G_TYPE_CHECK_INSTANCE_CAST ((o), GSF_OUTPUT_CRYPT_TYPE, GsfOutputCrypt))
#define GSF_IS_OUTPUT_CRYPT(o)       (G_TYPE_CHECK_INSTANCE_TYPE ((o), GSF_OUTPUT_CRYPT_TYPE))

typedef struct _GsfOutputCrypt GsfOutputCrypt;

GType      gsf_output_crypt_get_type     (void);
GsfOutput *gsf_output_crypt_new          (GsfOutput       *sink,
					  const char      *password,
					  GError         **err);


G_END_DECLS

#endif /* GSF_OUTPUT_CRYPT_H_ */
