#!/bin/sh

# This is a convenience script that works around some limitations in
# the current dbus-binding-tool. It will probably become unnecessary
# in the future.

set -e

ANT="    \<annotation name=\"org.freedesktop.DBus.GLib.ClientCSymbol\" value="

grep -v "^#" - | while read IF_NAME IF_FILE
do
    echo "$IF_NAME > $IF_FILE.xml"

    IF_UNAME=`echo $IF_FILE | sed s/-/_/g`
    IF_BASE=`echo $IF_NAME | cut -f1 -d.`
    IF_IN_FILE="$top_srcdir/xml/orig/$IF_FILE.xml"
    IF_OUT_FILE="$top_builddir/xml/modified/$IF_FILE.xml"

    # strip the DBus introspection definition
    perl -ne '$/=undef; s/<interface name.*DBus.*>(.|\n)*?<\/interface>//;
    print "$_"' $IF_IN_FILE > $IF_OUT_FILE

    # strip the redefinition of the channel base interface
    if [ "$IF_BASE" != "$IF_NAME" ]; then
        perl -ni -e '$/=undef; s/<interface name.*'$IF_BASE'.>(.|\n)*?<\/interface>//; print "$_"' $IF_OUT_FILE
    fi

    # add the annotation tag
    sed -i s/org.freedesktop.Telepathy.$IF_BASE.*$/\&\\n"$ANT\"$IF_UNAME\"\/\>"/ $IF_OUT_FILE
done

