#!/usr/bin/python

#doc: Sends some NOTIFY advertisement messages with invalid values in the NT header
#Test Type: Stress testing
#Test ID: 5.5
#Description: The NT (notification type) header in the SSDP (NOTIFY) messages, describes wrongly the 
#            type of the device being advertised. So, this test aims to inform all the UPnP entities 
#            in the network to a invalid/promiscous device, with wrong services and actions.
#

from test import start, finish, host
from stress.notify_sender import UDPSendMsgSession
import sys

notify_type = 'notify_ssdp_alive_invalid_nt'

# max number of NOTIFYs
max_notify_number = 50

port = 38400

p = start('igd_cp')

udp_send_msgs_session = UDPSendMsgSession()
udp_send_msgs_session.send_notify_message_from_file(notify_type, max_notify_number, host)

sys.exit(finish(p))
