/**
 * 	CyberLink Trusted IGD Control Point
 * 
 *	File: igd_cp.c
 *
 * 	@author	Rosfran Lins Borges
 */

#include <cybergarage/upnp/cupnp.h>
#include <stdlib.h>
#include <stdio.h>
#include "common.h"

CgUpnpControlPoint *controlPoint = NULL;

/**
 *
 */
int main( int argc, char* argv[] )
{
	int i = 0;
	
	controlPoint = cg_upnp_controlpoint_new();
	
	if ( controlPoint != NULL ) {
		if ( cg_upnp_controlpoint_start(controlPoint) == FALSE) {
			fprintf(stderr, "Couldn't start the IGD control point!!!\n");
			exit(0);
		}
		
		while ( i < 10 ) {
			cg_upnp_controlpoint_search( controlPoint, 
					"urn:schemas-upnp-org:device:InternetGatewayDevice:1" );
			++i;
		}
		
	} else {
		fprintf(stderr, "Couldn't create instance to the Control Point!!!\n");
		exit(0);
	}
	
	printf(SYNC_STRING);
	fflush(NULL);
	getchar();	

        cg_upnp_controlpoint_stop(controlPoint);
        cg_upnp_controlpoint_delete(controlPoint);
	
	return 0;
}
