/**
 * Clinkc-av control point test tool
 *
 * Rendering Control Service tests
 *
 * Copyright (c) 2006 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */

#include <cybergarage/renderingcontrol/crenderingcontrol.h>
#include <cybergarage/renderingcontrol/crcscontrolpoint.h>
#include <cybergarage/renderingcontrol/crcsactionarguments.h>
#include <cybergarage/avcontrol/cavcontrolpoint.h>

#include <math.h>

#include "cptest.h"
#include "rcstest.h"

AVCPSubTestCase rcs_tc[NUM_RCS_TEST_CASES] = 
{
	{TEST_CASE_RCS_LIST_PRESETS, CG_UPNP_STATUS_ACTION_FAILED, cp_test_rcs_list_presets, NULL},
	{TEST_CASE_RCS_SELECT_PRESET, CG_UPNP_STATUS_ACTION_FAILED, cp_test_rcs_select_preset, NULL}
};

int cp_test_rcs_print_statistics()
{
	int i = 0;
	int passed = 0;
	
	printf("\n************************ Rendering Control test results ************************\n");

	/* Print results */
	for (i = 0; i < NUM_RCS_TEST_CASES; i++)
	{
		if (cg_upnp_av_control_iserrorcodesuccessful(rcs_tc[i].result))
		{
			printf("%s: PASS\n", rcs_tc[i].name);
			passed++;
		}
		else
		{
			printf("%s: FAIL (%d)\n",
				rcs_tc[i].name, rcs_tc[i].result);
		}
	}
	
	printf("\nRendering Control pass rate: %d of %d (%.0f%%)\n",
		passed, NUM_RCS_TEST_CASES, 
		ceil(((float) passed / (float) NUM_RCS_TEST_CASES) * (float) 100));
	
	return passed;
}

int cp_test_rcs(CgUpnpControlPoint* cp)
{
	int i = 0;
	BOOL retval = TRUE;
	char* udn = NULL;
	SUB_TEST_CASE_FUNCTION func = NULL;
	
	printf("\nBEGIN: cp_test_rcs\n");

	/* Get a device with RCS capabilities */
	udn = cp_test_get_device_udn_with_service(cp, CG_UPNP_RCS_SERVICE_TYPE);
	if (udn == NULL)
	{
		printf("END: cp_test_rcs\n");
		return FALSE;
	}
	
	/* Run thru test cases */
	for (i = 0; i < NUM_RCS_TEST_CASES; i++)
	{
		func = rcs_tc[i].func;
		rcs_tc[i].result = func(cp, udn);

		/* One failed sub test case is enough to fail the RCS test */
		if (!cg_upnp_av_control_iserrorcodesuccessful(rcs_tc[i].result))
		{
			retval = FALSE;
		}
	}
	
	printf("\nRCS TEST RESULTS:\n");
	
	/* Print results */
	for (i = 0; i < NUM_RCS_TEST_CASES; i++)
	{
		if (cg_upnp_av_control_iserrorcodesuccessful(rcs_tc[i].result))
		{
			printf("%s: PASS\n", rcs_tc[i].name);
		}
		else
		{
			printf("%s: FAIL (%d)\n",
				rcs_tc[i].name, rcs_tc[i].result);
		}
	}

	/* Free extra data */
	for (i = 0; i < NUM_RCS_TEST_CASES; i++)
	{
		if (rcs_tc[i].result_data != NULL)
		{
			free(rcs_tc[i].result_data);
			rcs_tc[i].result_data = NULL;
		}
	}
	
	free(udn);
	
	printf("END: cp_test_rcs\n");
	
	return retval;
}

int cp_test_rcs_list_presets(CgUpnpControlPoint* cp, char* udn)
{
	int retval = 0;
	char* errorString = NULL;
	char* instanceID = "0";
        char* presetString = NULL;
	int index = -1;

	printf("BEGIN: cp_test_rcs_list_presets\n");
	
        cg_upnp_controlpoint_lock(cp);

        retval = cg_upnp_av_rcs_control_listpresets(
                cg_upnp_controlpoint_getdevicebyudn(cp, udn),
		&errorString,
                &instanceID,
                &presetString);

        cg_upnp_controlpoint_unlock(cp);

        if (cg_upnp_av_control_iserrorcodesuccessful(retval) && *presetString)
        {
		index = cp_test_find_test_case((AVCPTestCase*) rcs_tc, 
			NUM_RCS_TEST_CASES, TEST_CASE_RCS_LIST_PRESETS);
		
		rcs_tc[index].result_data = (void*) cg_strdup(presetString);
		
		printf("Presets: %s\n", presetString);
        }
	else
	{
		printf("Unable to invoke action: %d (%s)\n", 
			retval, errorString);
		free(errorString);
	}

	free(presetString);
	
	printf("END: cp_test_rcs_list_presets\n");
	
	return retval;
}

int cp_test_rcs_select_preset(CgUpnpControlPoint* cp, char* udn)
{
	int retval = 0;
	char* errorString = NULL;
	char* instanceID = "0";
        char* presetString = NULL;
	CgStringTokenizer* tok = NULL;
	int index = -1;
	
	printf("BEGIN: cp_test_rcs_select_preset\n");
	
	/* Find the results from ListPresets action */
	index = cp_test_find_test_case((AVCPTestCase*) rcs_tc, 
		NUM_RCS_TEST_CASES, TEST_CASE_RCS_LIST_PRESETS);
	
	if (rcs_tc[index].result_data == NULL)
	{
		return -1;
	}
	
	/* Find all presets and try to activate each of them */
	tok = cg_string_tokenizer_new((char*) rcs_tc[index].result_data, ",");
	while (cg_string_tokenizer_hasmoretoken(tok))
	{
		presetString = cg_string_tokenizer_nexttoken(tok);
		
		cg_upnp_controlpoint_lock(cp);

		retval = cg_upnp_av_rcs_control_selectpreset(
			cg_upnp_controlpoint_getdevicebyudn(cp, udn),
			&errorString,
			&instanceID,
			&presetString);
		
		cg_upnp_controlpoint_unlock(cp);
		
		if (!cg_upnp_av_control_iserrorcodesuccessful(retval))
		{
			printf("Unable to invoke action: %d (%s)\n",
				retval, errorString);
			
			free(errorString);
			
			/* Give up if even one preset setting fails */
			break;
		}
		else
		{
			printf("Selected preset: %s\n", presetString);
		}
	}

	cg_string_tokenizer_delete(tok);

	printf("END: cp_test_rcs_select_preset\n");
	
	return retval;
}
