/*
 * UPnP Browser for Maemo
 *
 * playlist.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
 
#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <gtk/gtk.h>
#include <cybergarage/util/clist.h>
#include <cybergarage/util/cstring.h>

typedef struct _PlaylistEntry
{
	BOOL headFlag;
	struct _PlaylistEntry* prev;
	struct _PlaylistEntry* next;

	CgString* trackName;
	CgString* trackURI;
	CgString* rendererUDN;
	CgString* serverUDN;

} PlaylistEntry, Playlist;

/****************************************************************************
 * Playlist
 ****************************************************************************/

Playlist* playlist_new();
void playlist_delete(Playlist* list);

#define playlist_clear(list) \
	cg_list_clear((CgList*) list, \
		(CG_LIST_DESTRUCTORFUNC) playlist_entry_delete)

#define playlist_size(list) \
	cg_list_size((CgList*) list)

#define playlist_gets(list) \
	(PlaylistEntry*) cg_list_next((CgList*) list)

#define playlist_add(list, entry) \
	cg_list_add((CgList*) list, (CgList*) entry)

/****************************************************************************
 * Playlist Entry
 ****************************************************************************/

PlaylistEntry* playlist_entry_new();
void playlist_entry_delete(PlaylistEntry* entry);

#define playlist_entry_settrackname(entry, value) \
	cg_string_setvalue(entry->trackName, value)

#define playlist_entry_gettrackname(entry) \
	cg_string_getvalue(entry->trackName)

#define playlist_entry_settrackuri(entry, value) \
	cg_string_setvalue(entry->trackURI, value)

#define playlist_entry_gettrackuri(entry) \
	cg_string_getvalue(entry->trackURI)

#define playlist_entry_setrendererUDN(entry, value) \
	cg_string_setvalue(entry->rendererUDN, value)

#define playlist_entry_getrendererUDN(entry, value) \
	cg_string_getvalue(entry->rendererUDN)

#define playlist_entry_setserverUDN(entry, value) \
	cg_string_setvalue(entry->serverUDN, value)
	
#define playlist_entry_getserverUDN(entry, value) \
	cg_string_getvalue(entry->serverUDN)

#define playlist_entry_next(entry) \
	(PlaylistEntry*) cg_list_next((CgList*) entry)

#define playlist_entry_prev(entry) \
	(PlaylistEntry*) cg_list_prev((CgList*) entry)

#endif
