/* Certificate Management library
 * 
 * Copyright (C) 2005 Nokia. All rights reserved.
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/**
	Tests libcst's isvalid

	To compile: gcc -o isvalid_tester `pkg-config --libs --cflags glib-2.0` -lcst isvalid_tester.c
*/

#include <glib.h>
#include <stdio.h>
#include <cst.h>

#define PASSWORD NULL

int main(int argc, char** argv)
{
	GSList* certificates = NULL;
	GSList* last_cert = NULL;
	guint cert_id;
	X509* cert = NULL;	
	GTimeVal timeval;
	glong last_seconds;	

	CST* cst = CST_open_file("certman.cst", TRUE, PASSWORD);

	if (cst == NULL)
	{
		fprintf(stderr, "Unable to open certificate store.\n");
		return -1;
	}

	certificates = CST_search_by_folder(cst,
			    		    CST_FOLDER_CA);
	//certificates = g_slist_concat(certificates, CST_search_by_folder(cst, CST_FOLDER_PERSONAL));				    
    //    certificates = g_slist_concat(certificates, CST_search_by_folder(cst, CST_FOLDER_OTHER));
    //    certificates = g_slist_concat(certificates, CST_search_by_folder(cst, CST_FOLDER_SITE));

    int state = 0;
	while(certificates != NULL)
	{
		cert_id = GPOINTER_TO_UINT(certificates->data);
		cert = CST_get_cert(cst, cert_id);

		fprintf(stderr, "Calling CST_get_state for cert #%d\n", cert_id);

		g_get_current_time(&timeval);	
		last_seconds = timeval.tv_sec;

        state = CST_get_state(cst, cert);
		fprintf(stderr, "Certificate state is %i\n", state);
		
		g_get_current_time(&timeval);
		last_seconds = timeval.tv_sec - last_seconds;
		fprintf(stderr, "This call took approx. %ld seconds\n\n", last_seconds);

		last_cert = certificates;
		certificates = certificates->next;
		g_slist_free_1(last_cert);
	}
	
	CST_free(cst);

	return 0;
}
