/*
 * Copyright © 2004-2006 Nokia Corporation
 *
 * Permission to use, copy, modify, distribute and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the authors and/or copyright holders
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  The authors and
 * copyright holders make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without any express
 * or implied warranty.
 *
 * THE AUTHORS AND COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Daniel Stone <daniel.stone@nokia.com>
 */

#ifdef HAVE_KDRIVE_CONFIG_H
#include <kdrive-config.h>
#endif

#include "omap.h"
#include "fbdev.h"
#include "scrnintstr.h"

#define setupPlane(x, type, active) omapSetupPlane(omapc, x##_NUM, type, \
                                                   x##NAME, active)

#define OMAP_PLANE_DISPC_GFX_NUM
#define OMAP_PLANE_DISPC_GFX_NUM

static OmapPlaneInfo *omapSetupPlane(OmapCardInfo *omapc, OmapPlaneType type,
                                     char *name)
{
    OmapPlaneInfo *plane = NULL;

    if (access(name, O_RDWR) != 0) {
        DebugF("omapSetupPlane: couldn't open %s\n", name);
        return NULL;
    }

    plane = xcalloc(sizeof(OmapPlaneInfo), 1);
    if (!plane) {
        ErrorF("omapSetupPlane: couldn't allocate plane\n");
        return NULL;
    }

    plane->type = type;
    plane->filename = name;
    plane->maxWidth = 800;
    plane->maxHeight = 480;
    plane->active = 0;

    return plane;
}

static Bool omapCardInit(KdCardInfo *card)
{
    OmapCardInfo *omapc;
    OmapPlaneInfo *gfxPlane;

    ENTER();

    omapc = (OmapCardInfo *)xcalloc(sizeof(OmapCardInfo), 1);
    if (!omapc)
        return FALSE;

    if (!fbdevInitialize(card, &omapc->fbdev)) {
        xfree(omapc);
        return FALSE;
    }

    gfxPlane = omapSetupPlane(omapc, OMAP_PLANE_DISPC_GFX, "/dev/fb0");
    if (!gfxPlane)
        FatalError("omapCardInit: couldn't open dispc gfx plane\n");

    if (omapSetupPlane(omapc, OMAP_PLANE_DISPC_VID, "/dev/fb1"))
        DebugF("omapCardInit: added first dispc vid plane\n");
    if (omapSetupPlane(omapc, OMAP_PLANE_DISPC_VID, "/dev/fb2"))
        DebugF("omapCardInit: added second dispc vid plane\n");
    if (omapSetupPlane(omapc, OMAP_PLANE_EXT_VID, "/dev/fb3"))
        DebugF("omapCardInit: added ext vid plane\n");

    card->driver = omapc;
    LEAVE();

    return TRUE;
}


static Bool omapScreenInit(KdScreenInfo *screen)
{
    OmapScreenInfo *omaps;

    ENTER();

    omaps = (OmapScreenInfo *)xcalloc(sizeof(OmapScreenInfo), 1);
    if (!omaps)
        return FALSE;

    omaps->omapc = screen->card->driver;
    /* COUGH INCREDIBLE HACK COUGH */
    screen->card->driver = &omaps->omapc->fbdev;
    omaps->screen = screen;
    screen->driver = omaps;	
    screen->softCursor = FALSE;

    screen->width = 800;
    screen->height = 480;
    if (screen->fb[0].depth == 0)
        screen->fb[0].depth = 16;

    if(!fbdevScreenInitialize(screen, &omaps->fbdev)) {
        ErrorF("omapScreenInit: fbdevScreenInitialize failed");
        screen->driver = NULL;
        xfree(omaps);
        return FALSE;
    }

    LEAVE();

    return TRUE;
}

static Bool omapInitScreen(ScreenPtr pScreen)
{
    ENTER();

    omapVideoInit(pScreen);
    
    LEAVE();
    return fbdevInitScreen(pScreen);
}

static Bool omapCreateResources(ScreenPtr pScreen)
{
    ENTER();

    if (!omapCreateDrawResources(pScreen)) {
        LEAVE();
        return FALSE;
    }

    LEAVE();
    return fbdevCreateResources(pScreen);
}

static Bool omapDPMS(ScreenPtr pScreen, int mode)
{
    return TRUE;
}

static void omapScreenFini(KdScreenInfo *screen)
{
    ENTER();
    OmapScreenInfo *omaps = (OmapScreenInfo *)screen->driver;

    omapVideoFini(screen->pScreen);
    omapRemoveDrawResources(screen->pScreen);

    fbdevScreenFini(screen);
    xfree(omaps);
    screen->driver = NULL;
    LEAVE();
}


KdCardFuncs omapFuncs = {
    .cardinit         = omapCardInit,
    .scrinit          = omapScreenInit,
    .initScreen       = omapInitScreen,
    .createRes        = omapCreateResources,
    .dpms             = omapDPMS,
    .scrfini          = omapScreenFini,

    .preserve         = fbdevPreserve,
    .enable           = fbdevEnable,
    .finishInitScreen = fbdevFinishInitScreen,
    .disable          = fbdevDisable,
    .restore          = fbdevRestore,
    .cardfini         = fbdevCardFini,

    .getColors        = fbdevGetColors,
    .putColors        = fbdevPutColors,
};
