/*
    Copyright (C) 2003 Otso Kiveks, <otso.kivekas@movial.fi>

    This file is part of Outo.

    Outo is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published 
    by the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    Outo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Outo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* this is an internal header of outo*/
#include <outo.h>

#ifndef DEBUG
#define DEBUG 0
#endif


#ifndef __DEFINED_OUTO_REPORT_H_
#define __DEFINED_OUTO_REPORT_H_

/* 
   width of description field on plain output 
   change to int if needed somewhere
*/
#define explwidth 35

/*--------------- OUTPUT MACROS -------------------*/


#define DPRINT(s) if(DEBUG){printf(s);fflush(stdout);}

/** 
 * Prints tests case result line without end of line
 * @paramc test number
 * @param tc a pointer to testcase 
 * @param ask the condition that needs to be true for test to pass 
 */
#define PRINTT_(c, tc, ask) printf("%3i: %-*.*s %s", \
 c, explwidth, explwidth, tc->description, \
 ask ? "passed" : "failed");

/** 
 * Prints tests case result line and end of line
 * @paramc test number
 * @param tc a pointer to testcase 
 * @param ask the condition that needs to be true for test to pass 
 */
#define PRINTT(c, tc, ask) {PRINTT_(c, tc, ask) printf("\n");}



typedef struct _stat {
  int tests;
  int pass;
  int fail;
  int cur;
} stat;



/** starts the test report*/
void begin_report();

/** starts reporting a library */
void begin_lib_report(char *name);

/** ends reporting a library */
void end_lib_report(stat *lib, char *name);

/** finishes the test report */
void end_report(stat *total);

/** reports a test case result */
void report(testcase *tcase, int statloc, stat *lib);



#endif



