/**
  @file common.h
 
  Copyright (C) 2004 Nokia Corporation. All rights reserved.
 
  @author Janne Yllehto <janne.ylalehto@nokia.com>  

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef _COMMON_H_
#define _COMMON_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include <linux/if_ether.h>
#include <linux/compiler.h>
#include <iwlib.h>
#include <wireless.h>
#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <wlancond.h>

/* Scan results helper struct */
typedef struct scan_results_t 
{
        char           ssid[WLANCOND_MAX_SSID_SIZE+1];
        unsigned char  bssid[ETH_ALEN];
        gint32         rssi;
        guint32        channel;
        guint32        cap_bits;
} scan_results_t;

/* Generic WPA IE storage type */
typedef struct wpa_ie_list_t 
{
        unsigned char  bssid[ETH_ALEN];
        guint32        ie_len;
        guint8         *wpa_ie;
} wpa_ie_list_t;

/* Own WPA IE storage type */
typedef struct wpa_ie_save_t 
{
        guint32 ie_valid;
        guint32 ie_len;
        unsigned char *ie;
} wpa_ie_save_t;


/* WLAN status and state is kept in this struct. 
   Scanning is separated from the state because scanning
   can be initiated separately from other WLAN activity
*/
typedef struct wlan_status_t
{
        /* Scanning state */
        guint scan;
        /* WLAN state */
        guint state;
        /* Power state */
        guint power;
        /* Network mode */
        guint mode;
        /* Cipher suites */
        guint pairwise_cipher;
        guint group_cipher;
        /* Our WPA IE */
        struct wpa_ie_save_t wpa_ie;
} wlan_status_t;

/* WLAN force type e.g. in WLAN interface shutdown */
typedef enum {
        FORCE_NO,
        FORCE_YES,
        FORCE_MAYBE
} force_t;

/* WPA Information Element status */
#define IE_NOT_VALID 0
#define IE_VALID     1

/* Scan state */
enum scan_state {
        SCAN_NOT_ACTIVE = 0,
        SCAN_ACTIVE
};

/* Generic WLAN state */
enum wlan_state {
        WLAN_NOT_INITIALIZED = 0,
        WLAN_INITIALIZED,
        WLAN_INITIALIZED_FOR_SCAN,
        WLAN_NO_ADDRESS,
        WLAN_CONNECTED
};

/* WLAN power defines */
#define WLANCOND_TX_POWER10DBM  10 // 10mW = 10dBm
#define WLANCOND_TX_POWER100DBM 20 // 100mW = 20dBm

/* WLAN power state */
enum wlan_power_state {
        WLANCOND_POWER_ON = 1,
        WLANCOND_LONG_CAM,
        WLANCOND_SHORT_CAM,
        WLANCOND_FULL_POWERSAVE
};

#define WLANCOND_DEFAULT_SLEEP_TIMEOUT 1000 // 1000ms
#define WLANCOND_LONG_CAM_TIMEOUT 4000 // 4000ms

/* Signal sending defines */
#define NO_SIGNAL           0
#define DISCONNECTED_SIGNAL 1

#define WLANCOND_MAX_NETWORKS 30

/* Gconf paths */
#define SLEEP_GCONF_PATH "/system/osso/connectivity/IAP/wlan_sleep_timeout"

/* Common functions */
gboolean monitor_wi(void);
void del_all_interface_data(void);
struct wireless_iface *iw_get_interface_data(int ifindex);
int print_event_token(struct iw_event *	event, struct iw_range *range, 
                      int has_range, struct scan_results_t *scan_results);
void send_dbus_scan_results(GSList* scan_results_save, const char* sender);
int get_we_device_name(void);
GSList *save_scan_results(struct scan_results_t *scan_results,
                         GSList *scan_results_save);
void clean_scan_results(GSList *scan_results_save);
int socket_open(void);
void init_iwreq(struct iwreq* req);
int ask_scan_results(void);
void set_wlan_state(int new_state, int send_signal, force_t force);
int get_wlan_state(void);
void set_scan_state(guint new_state);
int get_scan_state(void);
int init_dbus_handler(void);
int clean_dbus_handler(void);
int parse_rsn_cipher_suite(guint8 *suite);
int parse_rsn_key_mgmt_suite(guint8 *suite);
int parse_wpa_cipher_suite(guint8* suite);
int parse_wpa_key_mgmt_suite(guint8 *suite);
void clear_wpa_mode(void);
int wpa_ie_push(unsigned char* ap_mac_addr, unsigned char* ap_wpa_ie, 
                int ap_wpa_ie_len);
int wpa_mic_failure_event(dbus_bool_t key_type, dbus_bool_t is_fatal);
gboolean get_wpa_mode(void);
void disconnected_signal(void);
void mode_change(const char *mode);
#ifdef ACTIVITY_CHECK
void activity_check(dbus_bool_t activity);
#endif
void init_cover_state(void);
void update_own_ie(unsigned char* wpa_ie, guint wpa_ie_len);
gboolean set_power_state(guint state, int sock);
int get_encryption_info(void);
void remove_connect_timer(void);
int disassociate_eap(void);
int get_mode(void);
DBusHandlerResult wlancond_req_handler(DBusConnection *connection,
                                       DBusMessage *message, void *user_data);

#endif /* _COMMON_H_ */
