/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <config.h>
#include <string.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gsf/gsf-utils.h>

#include "ob-backend.h"
#include "ob-archiver.h"

#define ARCHIVE_FILENAME "test.zip"

int
main (int argc, char *argv[])
{
	ObBackend   *backend;
	ObArchiver  *archiver;
	char        *basedir, *tmp;
	GnomeVFSURI *data_uri, *archive_uri;
	gboolean     write, read;

	gnome_vfs_init ();
	gsf_init ();

	backend = ob_backend_get ();

	write = TRUE;
	read = TRUE;
	
	if (argc > 1) {
		if (strcmp (argv[1], "-w") != 0) {
			write = FALSE;
		}
		if (strcmp (argv[1], "-r") != 0) {
			read = FALSE;
		}
	}	

	basedir = "/home/rhult/gsf-test";
	
	tmp = g_build_filename (basedir, ARCHIVE_FILENAME, NULL);
	archive_uri = gnome_vfs_uri_new (tmp);
	g_free (tmp);

	if (write) {
		/*
		 * Packing.
		 */
		tmp = g_build_filename (basedir, "data", NULL);
		data_uri = gnome_vfs_uri_new (tmp);
		g_free (tmp);

		archiver = ob_archiver_new (archive_uri, data_uri);
		
		if (!ob_archiver_pack (archiver)) {
			g_print ("Traverse failed\n");
			return 1;
		}
		
		gnome_vfs_uri_unref (data_uri);

		g_print ("Packed %d files, %d bytes\n",
			 ob_archiver_get_processed_files (archiver),
			 (int) ob_archiver_get_processed_size (archiver));

		//ob_archiver_unref (archiver);
	}
	
	if (read) {
		/*
		 * Unpacking.
		 */
		tmp = g_build_filename (basedir, "unpacked", NULL);
		data_uri = gnome_vfs_uri_new (tmp);
		g_free (tmp);

		archiver = ob_archiver_new (archive_uri, data_uri);

		if (!ob_archiver_unpack (archiver)) {
			g_print ("Read failed\n");
			return 1;
		}

		gnome_vfs_uri_unref (data_uri);

		g_print ("Unpacked %d files, %d bytes\n",
			 ob_archiver_get_processed_files (archiver),
			 (int) ob_archiver_get_processed_size (archiver));

		//ob_archiver_unref (archiver);
	}

	gnome_vfs_uri_unref (archive_uri);

	g_object_unref (backend);
	
	gsf_shutdown ();
	gnome_vfs_shutdown ();
		
	return 0;
}
