/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <config.h>
#include <string.h>
#include <glib.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus-glib-lowlevel.h>

#include <libosso.h>

#include "ob-dbus-service.h"


#define d(x) x

#define APP_NAME "backup"


static DBusConnection *bus_conn;
static osso_context_t *osso;


static gboolean
test_client_init (void)
{
	DBusError error;

  	dbus_error_init (&error);
	bus_conn = dbus_bus_get (DBUS_BUS_SESSION, &error);
  	if (!bus_conn) {
		g_warning ("Failed to connect to the D-BUS daemon: %s", error.message);
		dbus_error_free (&error);
		return FALSE;
	}
  
	dbus_connection_setup_with_g_main (bus_conn, NULL);
  
	return TRUE;
}

static void
send_cancel (void)
{
	DBusMessage *message;
	DBusMessage *reply;
	DBusError    error;

	message = dbus_message_new_method_call (OB_DBUS_SERVICE,
						OB_DBUS_PATH,
						OB_DBUS_INTERFACE,
						OB_DBUS_METHOD_CANCEL);

	g_assert (message != NULL);

	dbus_error_init (&error);
	reply = dbus_connection_send_with_reply_and_block (bus_conn,
							   message, -1,
							   &error);
  
	dbus_message_unref (message);

	if (dbus_error_is_set (&error)) {
		g_print ("Got error when sending cancel: %s\n", error.message);
		dbus_error_free (&error);
		return;
	}
  
	dbus_message_unref (reply);
}

static void
send_activate (void)
{
	osso_return_t ret;
	
        ret = osso_rpc_run_with_defaults (osso,
					  APP_NAME,
					  OB_DBUS_METHOD_ACTIVATE,
					  NULL,
					  DBUS_TYPE_INVALID);

	if (ret == OSSO_ERROR) {
		g_print ("Error activating: %d\n", ret);
	}
}

static void
print_usage (const char *name)
{
	g_printerr ("Usage: %s OPTION\nOptions:\n"
		    "  -c   send a cancel message\n"
		    "  -a   send an activation message\n",
		    name);
}

int
main (int argc, char **argv)
{
	GMainLoop      *loop;

	osso = osso_initialize ("backup_test", VERSION, FALSE, NULL);
	if (!osso) {
		g_printerr ("Couldn't init osso.\n");
		return 1;
	}
	
	if (!test_client_init ()) {
		return 1;
	}

	loop = g_main_loop_new (NULL, FALSE);

	if (argc != 2) {
		print_usage (argv[0]);
		return 1;
	}

	if (strcmp (argv[1], "-c") == 0) {
		send_cancel ();
	}
	else if (strcmp (argv[1], "-a") == 0) {
		send_activate ();
	} else {
		print_usage (argv[0]);
		return 1;
	}
	
	return 0;
}

