/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_UI_H_
#define OB_UI_H_

#include <gtk/gtk.h>

#include "ob-category.h"

G_BEGIN_DECLS

#define OB_UI_WIDGET_SPACING 6

/* Note: This is supposed to be added to the platform somewhere in the
 * future.
 */
#define OB_UI_MARGIN_DEFAULT 6
#define OB_UI_MARGIN_DOUBLE 12

typedef enum {
        OB_UI_OPERATION_BACKUP,
        OB_UI_OPERATION_RESTORE
} ObUiOperation;

typedef struct _ObProgressDialog ObProgressDialog;
struct _ObProgressDialog {
        GtkWidget *dialog;
        GtkWidget *progress_bar;
        GtkWidget *progress_label;

	GtkWidget *conflict_dialog;
	
	gint       processed_files;
	gint       total_files;
	gint       complete;

        ObUiOperation operation;
	
        GError    *error;
};

enum {
        OB_UI_RESPONSE_CHANGE        = 1,
        OB_UI_RESPONSE_ERROR         = 2,
        OB_UI_RESPONSE_FINISHED      = 3,
        OB_UI_RESPONSE_CANCELLED     = 4,
        OB_UI_RESPONSE_YES_TO_ALL    = 5,
	OB_UI_RESPONSE_CARD_REMOVED  = 6,
	OB_UI_RESPONSE_CARD_INSERTED = 7
};

GtkWidget *       ob_ui_dialog_new                 (const gchar      *title,
						    GtkWindow        *parent,
						    const gchar      *first_button_text,
						    ...);
GtkWidget *       ob_ui_message_dialog_new         (GtkWindow        *parent,
						    GtkMessageType    type,
						    const gchar      *title,
						    const gchar      *message,
						    const gchar      *first_button_text,
						    ...);
GtkWidget *       ob_ui_label_new                  (const gchar      *str);
ObProgressDialog *ob_ui_progress_dialog_new        (GtkWindow        *parent,
						    ObUiOperation     operation,
						    gint              total_files);
void              ob_ui_progress_dialog_update     (ObProgressDialog *dialog,
						    gint              files,
						    gint              complete,
						    ObCategory        category);
void              ob_ui_progress_dialog_destroy    (ObProgressDialog *dialog);
void              ob_ui_progress_dialog_set_string (ObProgressDialog *dialog,
						    const gchar      *str);

G_END_DECLS

#endif /* OB_UI_H_ */
