/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <config.h>
#include <glib.h>

#include "ob-types.h"

GType
ob_conflict_type_get_type (void)
{
	static GType etype = 0;
	if (etype == 0) {
		static const GEnumValue values[] = {
			{ OB_CONFLICT_TYPE_FILE_FILE,
			  "OB_CONFLICT_TYPE_FILE_FILE",
			  "file-file" },
			{ OB_CONFLICT_TYPE_FILE_DIR,
			  "OB_CONFLICT_TYPE_FILE_DIR",
			  "file-dir" },
			{ OB_CONFLICT_TYPE_DIR_FILE,
			  "OB_CONFLICT_TYPE_DIR_FILE",
			  "dir-file" },
			{ 0, NULL, NULL }
		};
		etype = g_enum_register_static ("ObConflictType", values);
	}
	return etype;
}
