/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_ERROR_H_
#define OB_ERROR_H_

#include <glib.h>

G_BEGIN_DECLS

typedef enum {
	OB_ERROR_GENERIC = 0,

	/* Backup */
	OB_ERROR_BACKUP_NO_MEMORY_CARD, 	/* BKP-NOT015 */
	OB_ERROR_BACKUP_READONLY,       	/* BKP-NOT016 */
	OB_ERROR_BACKUP_NO_SPACE,       	/* BKP-NOT017 */
	OB_ERROR_BACKUP_MEMORY_CARD_REMOVED,    /* BKP-NOT019 */
	OB_ERROR_BACKUP_GENERIC,		/* BKP-NOT025 */
	
	/* Restore */
	OB_ERROR_RESTORE_NO_MEMORY_CARD, 	/* BKP-NOT020 */
	OB_ERROR_RESTORE_NO_SPACE,       	/* BKP-NOT021 */
	OB_ERROR_RESTORE_MEMORY_CARD_REMOVED,   /* BKP-NOT022 */
	OB_ERROR_RESTORE_CORRUPT,        	/* BKP-NOT023 */
	OB_ERROR_RESTORE_WRONG_PASSWORD,	/* WID-INF148 */
	OB_ERROR_RESTORE_GENERIC		/* BKP-NOT027 */
} ObError;


#define OB_ERROR ob_error_quark ()
GQuark ob_error_quark (void) G_GNUC_CONST;

G_END_DECLS

#endif /* OB_ERROR_H_ */
