/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_CONFIG_H_
#define OB_CONFIG_H_

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ob-memory-card.h"

G_BEGIN_DECLS

typedef struct _ObConfig ObConfig;

void         ob_config_init                        (const char       *dir);
ObConfig *   ob_config_get                         (void);
void         ob_config_shutdown                    (void);
GnomeVFSURI *ob_config_get_memory_card_mountpoint  (ObConfig         *config,
						    ObMemoryCardType  type);
GnomeVFSURI *ob_config_get_gconf_dir               (ObConfig         *config);
GnomeVFSURI *ob_config_get_documents_dir           (ObConfig         *config);
int          ob_config_get_app_killer_delay        (ObConfig         *config);

/* Private API, only for testing. */
gboolean     _ob_config_init_empty                 (void);
void         _ob_config_set_memory_card_mountpoint (ObConfig         *config,
						    ObMemoryCardType  type,
						    GnomeVFSURI      *uri);
void         _ob_config_set_gconf_dir              (ObConfig         *config,
						    GnomeVFSURI      *uri);
void         _ob_config_set_documents_dir          (ObConfig         *config,
						    GnomeVFSURI      *uri);

G_END_DECLS

#endif /* OB_CONFIG_H_ */



