/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_ARCHIVER_H_
#define OB_ARCHIVER_H_

#include <glib-object.h>
#include <libgnomevfs/gnome-vfs.h>

G_BEGIN_DECLS

#define OB_TYPE_ARCHIVER            (ob_archiver_get_type ())
#define OB_ARCHIVER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
					OB_TYPE_ARCHIVER, ObArchiver))
#define OB_ARCHIVER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
					OB_TYPE_ARCHIVER, ObArchiverClass))
#define OB_IS_ARCHIVER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
					OB_TYPE_ARCHIVER))
#define OB_IS_ARCHIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
					OB_TYPE_ARCHIVER))
#define OB_ARCHIVER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
					OB_TYPE_ARCHIVER, ObArchiverClass))


typedef struct _ObArchiver      ObArchiver;
typedef struct _ObArchiverClass ObArchiverClass;
typedef struct _ObArchiverPriv  ObArchiverPriv;

#include "ob-backend.h"

struct _ObArchiver {
	GObject            parent;
	ObArchiverPriv    *priv;

	volatile gboolean  cancelled;
};

struct _ObArchiverClass {
	GObjectClass   parent_class;

	/* VTable */
	gpointer (*pack_thread_func)   (ObArchiver *archiver);
	gpointer (*unpack_thread_func) (ObArchiver *archiver);
};

typedef enum {
	ARCHIVER_RESULT_OK,
	ARCHIVER_RESULT_ERROR,
	ARCHIVER_RESULT_CANCELLED,
	ARCHIVER_RESULT_CONFLICT_CANCELLED
} ArchiverResult;


GType       ob_archiver_get_type             (void) G_GNUC_CONST;
ObArchiver *ob_archiver_new                  (GnomeVFSURI    *archive_uri,
					      GnomeVFSURI    *data_uri);
void        ob_archiver_set_backend          (ObArchiver     *archiver,
					      ObBackend      *backend);
ObBackend  *ob_archiver_get_backend          (ObArchiver     *archiver);
void        ob_archiver_set_replace_all      (ObArchiver     *archiver,
					      gboolean        replace_all);
gboolean    ob_archiver_get_replace_all      (ObArchiver     *archiver);


/* Progress reporting. */
void        ob_archiver_set_total_files      (ObArchiver     *archiver,
					      int             files);
int         ob_archiver_get_total_files      (ObArchiver     *archiver);
void        ob_archiver_set_total_size       (ObArchiver     *archiver,
					      gsize           size);
gsize       ob_archiver_get_total_size       (ObArchiver     *archiver);
gsize       ob_archiver_get_processed_size   (ObArchiver     *archiver);
int         ob_archiver_get_processed_files  (ObArchiver     *archiver);
void        ob_archiver_add_processed_size   (ObArchiver     *archiver,
					      gsize           size);
void        ob_archiver_add_processed_files  (ObArchiver     *archiver,
					      int             files);
void        ob_archiver_set_processed_size   (ObArchiver     *archiver,
					      gsize           size);
void        ob_archiver_set_processed_files  (ObArchiver     *archiver,
					      int             files);
void        ob_archiver_set_current_category (ObArchiver     *archiver,
					      ObCategory      category);
ObCategory  ob_archiver_get_current_category (ObArchiver     *archiver);


/* Packing/unpacking. */
gboolean    ob_archiver_pack_start_thread    (ObArchiver     *archiver);
gboolean    ob_archiver_unpack_start_thread  (ObArchiver     *archiver);


/* Cancellation. */
#define     ob_archiver_cancel(a) a->cancelled=TRUE
#define     ob_archiver_is_cancelled(a) a->cancelled

/* Event handling. */
void        ob_archiver_push_progress_event            (ObArchiver *archiver);
void        ob_archiver_push_progress_finalizing_event (ObArchiver *archiver);

void        ob_archiver_push_error_event     (ObArchiver     *archiver,
					      GError         *error);
void        ob_archiver_push_conflict_event  (ObArchiver     *archiver,
					      ObConflictType  type,
					      GnomeVFSURI    *uri,
					      time_t          existing_time,
					      time_t          backup_time);
void        ob_archiver_push_finished_event  (ObArchiver     *archiver);
void        ob_archiver_push_cancelled_event (ObArchiver     *archiver);

G_END_DECLS

#endif /* OB_ARCHIVER_H_ */



