/*
 * Maemo Games Startup
 * Copyright (c) 2006 INdT.
 * @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libosso.h>
#include "startup_ui.h"
#include "startup_i18n.h"

#include <startup_app.h>

#include <gtk/gtk.h>

#include <stdio.h>
#include <locale.h> 

int main (int argc, char** argv)
{
  StartupApp *app;
  StartupUI  *ui;
  
  if (argc < 2) {
    fprintf (stderr, "usage: %s config_file\n", argv[0]);
    return 1;
  }

  g_type_init();
  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
  
  gtk_init (&argc, &argv);

  app = startup_app_new ();  
  if (!startup_app_set_config_file (app, argv[1]))
    return 1;

  if (!startup_app_initialize (app)) 
    return 1;

  ui = startup_ui_new (app);

  gtk_main ();

  startup_app_destroy (app);

  return 0;
}
