/*
Simulate gps daemon. Used only when testing the gpsmgr API.

Copyright (C) 2006 Nokia Corporation. All rights reserved.

Author: Jukka Rissanen <jukka.rissanen@nokia.com>

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
The name of the author may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include "gpsmgr.h"

static int debug_mode = 1;

#define PDEBUG(fmt...) do {						\
    if (debug_mode) {							\
      struct timeval tv;						\
      gettimeofday(&tv, 0);						\
      printf("DEBUG[%d]:%ld.%ld:%s:%s():%d: ",				\
	     getpid(),							\
	     tv.tv_sec, tv.tv_usec,					\
	     __FILE__, __FUNCTION__, __LINE__);				\
      printf(fmt);							\
      fflush(stdout);							\
    }									\
  }while(0);

int term_flag = 0;

void terminate(int sig)
{
  PDEBUG("signal %d received\n", sig);
  term_flag = 1;
}

int main(int argc, char **argv)
{
  char *path = argv[0];
  char *dev = "/dev/rfcomm0";
  char *ctrl_sock = "/tmp/control";
  int ret, i, fd = -1;

  pid_t p = getpid();
  char *prog;

  prog=argv[0];

#if 0
  for (i=0; i<argc; i++) {
    PDEBUG("%d: [%d]=%s\n", p, i, argv[i]);
  }
#endif

#if 0
  ret = gpsmgr_gpsd_started(&fd);
  if (ret != 0) {
    PDEBUG("GPS daemon already running.\n");
    exit(-1);
  }
#endif

  PDEBUG("gpsd started, pid=%d\n", getpid());

  /* wait signal that parent sends to us */
  signal(SIGTERM, terminate);
  signal(SIGINT, terminate);

  PDEBUG("Program %s started.\n", prog);

  while(!term_flag) {

    usleep(500);
  }
  PDEBUG("stop gpsd_sim\n");

  return ret;
}
