/*
GPS daemon manager test program. Simulates an application that
uses the API. Use only in testing.

Copyright (C) 2006 Nokia Corporation. All rights reserved.

Author: Jukka Rissanen <jukka.rissanen@nokia.com>

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
The name of the author may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/


#include "gpsmgr.h"

static int debug_mode = 1;

#define PDEBUG(fmt...) do {						\
    if (debug_mode) {							\
      struct timeval tv;						\
      gettimeofday(&tv, 0);						\
      printf("DEBUG[%d]:%ld.%ld:%s:%s():%d: ",				\
	     getpid(),							\
	     tv.tv_sec, tv.tv_usec,					\
	     __FILE__, __FUNCTION__, __LINE__);				\
      printf(fmt);							\
      fflush(stdout);							\
    }									\
  }while(0);

int term_flag = 0;

void terminate(int sig)
{
  PDEBUG("signal %d received\n", sig);
  term_flag = 1;
}

#define MAX_DIR_LEN 128
static char cwd[MAX_DIR_LEN+1] = {0};
static int cwd_len = 0;

int main(int argc, char **argv)
{
  char *path = argv[0];
  char *dev = "/dev/rfcomm0";
  char *ctrl_sock = "/tmp/control";
  gpsmgr_t ctx = {0};
  int ret, i;
  int len, count = 0, locks;
  char buf[MAX_DIR_LEN+1];
  char *devices[]={ "barfoo", "foobar", 0 };

  pid_t p = getpid();
  char *prog;
  int num_of_clients = 0, cnt = 0;

  gpsmgr_set_debug_mode(1);

  getcwd(cwd, MAX_DIR_LEN);
  snprintf(buf, MAX_DIR_LEN, "%s/%s", cwd, "gpsd_sim");
  prog = buf;

  /* wait signal that parent sends to us */
  signal(SIGTERM, terminate);
  signal(SIGINT, terminate);

  PDEBUG("Program %s started.\n", prog);

  ret = gpsmgr_start(prog, devices, NULL, 0, 0, &ctx);
  if (ret != 0) {
    PDEBUG("start ret = %d\n", ret);
    perror("start");
    goto OUT;
  } else {
    PDEBUG("started %d\n", ctx.pid);
  }

  while(!term_flag) {

    /* At least one instance must be running */
    if (!gpsmgr_is_gpsd_running(&ctx, &num_of_clients, GPSMGR_MODE_JUST_CHECK)) {
      PDEBUG("ERROR, gpsd is not running, clients = %d\n", num_of_clients);
      ret = -1;
      goto OUT;
    }
    if (!(cnt % 10)) {
      PDEBUG("Num of clients running = %d\n", num_of_clients);
    }
    cnt++;

    //usleep(50);
    sleep(1);
  }
  PDEBUG("stop manager\n");

  ret = gpsmgr_stop(&ctx);
  if (ret != 0) {
    PDEBUG("stop ret = %d\n", ret);
    perror("stop");
  } else {
    PDEBUG("stopped %d\n", ctx.pid);
  }

  PDEBUG("Program %s stopped.\n", argv[0]);


 OUT:
  PDEBUG("Program stopped.\n");
  return ret;
}
