/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPAMRSINK_H__
#define __GST_DSPAMRSINK_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstadapter.h>
#include <gst/base/gstbasesink.h>

#include <dspaudio.h>
#include <dsp/interface_common.h>
#include <dsp/audio_dsptask.h>

G_BEGIN_DECLS

enum
{
  DSPAMR_PROP_MIME_MODE = DSPAUDIO_PROP_LAST,
};

#define GST_TYPE_DSPAMRSINK          (gst_dspamrsink_get_type())
#define GST_DSPAMRSINK(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPAMRSINK,GstDSPAMRSink))
#define GST_DSPAMRSINK_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPAMRSINK,GstDSPAMRSinkClass))
#define GST_IS_DSPAMRSINK(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPAMRSINK))
#define GST_IS_DSPAMRSINK_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPAMRSINK))


/* Audio signals and args */
enum
{
  DSPAMR_SIGNAL_STREAMID,
  DSPAMR_SIGNAL_LAST
};


typedef struct _GstDSPAMRSink GstDSPAMRSink;
typedef struct _GstDSPAMRSinkClass GstDSPAMRSinkClass;

/* AMR data write structure */
typedef struct amr_data_write
{
  unsigned short int dsp_cmd;
  unsigned short int data_size;
} AMR_DATA_WRITE;


struct _GstDSPAMRSink {
  GstBaseSink   sink;
  GstPad        *sinkpad;
  GstDSPAudio   *audio;
  GstAdapter    *adapter;

  gboolean       wide;
  gboolean       read_mime_header;
  guint          bandindex;
  guint          packet_index;

  // Length-related
  guint          current_framecount;
  guint64        current_bytes;
  gint64         total_length_bytes;
  gint64         total_framecount;
  gint64         avg_framecount;
  AMR_DATA_WRITE outbuf;
};

struct _GstDSPAMRSinkClass {
  GstBaseSinkClass parent_class;

  void (*stream_id) (GstDSPAMRSink *sink, gint id);
};

GType gst_dspamrsink_get_type(void);

G_END_DECLS

#endif /* __GST_DSPAMRSINK_H__ */
