/*
 * farsight-transport.h - Headers for FarsightTransportInfo
 *
 * Farsight Voice+Video library,
 * FarsightCodec
 * Copyright 2005 Collabora Ltd, 
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_TRANSPORT_H__
#define __FARSIGHT_TRANSPORT_H__

#include <glib.h>

#include "farsight-stream.h"

G_BEGIN_DECLS

typedef struct _FarsightTransportInfo FarsightTransportInfo;

/**
 * FarsightTransportInfo:
 * @candidate_id: string identifier of the candidate of which this transport is
 *                a part.
 * @component: number indicating which component of the candidate is formed by
 *             this transport
 * @ip: IP in dotted format
 * @port: Port to use
 * @proto: #FarsightNetworkProtocol for ip protocol to use as transport
 * @proto_subtype: a string specifying subtype of this protocol type if needed
 * @proto_profile: a string specifying a profile type for this protocol, if applicable
 * @preference: Value between
 * @type: Type of candidate
 * @username: Username to use to connect to client if necessary,
 *            NULL otherwise
 * @password: Username to use to connect to client if necessary,
 *            NULL otherwise
 *
 * Struct to hold information about a possible stream network transport.
 */
struct _FarsightTransportInfo
{
  const gchar *candidate_id;
  guint component;
  const gchar *ip;
  guint16 port;
  FarsightNetworkProtocol proto;
  const gchar *proto_subtype;
  const gchar *proto_profile;
  float preference;
  FarsightCandidateType type;
  const gchar *username;
  const gchar *password;
  /*< private >*/
  gpointer _padding[4];
};

void
farsight_transport_destroy (FarsightTransportInfo * trans);

FarsightTransportInfo *
farsight_transport_copy (const FarsightTransportInfo * trans);

void
farsight_transport_list_destroy (GList *transport_list);

GList *
farsight_transport_list_copy (const GList *transport_list);

GList *
farsight_transport_get_list_for_candidate_id (const GList *candidate_list, const
        gchar *candidate_id);

gboolean farsight_transport_are_equal (FarsightTransportInfo *trans1,
        FarsightTransportInfo *trans2);

G_END_DECLS
#endif
