import re
import socket
import os
import signal
import time
import httplib

def get_addrs():
    p = os.popen('ifconfig')
    data = p.read()
    r = p.close()
    assert r == None
    m = re.findall('inet addr:(\S*)', data)
    return m

def get_addr():
    t = get_addrs()
    t.remove('127.0.0.1')
    return t[0]

def wait_port(addr, port):
    s = socket.socket()
    r = 0
    while r == 0:
        r = 1
        try:
            s.bind((addr, port))
        except socket.error, e:
            r = 0
    s.close()

def wait_ports(ports):
    addr = get_addr()
    for j in ports:
        wait_port(addr, j)

def wait_string(file, string):
    while True:
        line = file.readline().strip()
        if line == string:
            return

def http_request(host, port, method, path, body = None, headers = {}):
    c = httplib.HTTPConnection(host, port)
    c.connect()
    c.request(method, path, body, headers)
    #return the response?
    return c

def httpmu_request(host, method, path, headers = {}):
    port = 1900
    msg = '%s %s HTTP/1.1\n' % (method, path)
    for i,j in headers.iteritems():
        line = '%s: %s\n' % (i, j)
        msg += line
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.sendto(msg, (host, port))

def cp_add_device(url):
    host = get_addr()
    path = '/'
    method = 'GET'
    headers = {'NT'       : 'upnp:rootdevice',
               'NTS'      : 'ssdp:alive',
               'USN'      : 'abc',
               'Location' : url}
    httpmu_request(host, method, path, headers)
    time.sleep(1)
    #hack: there is no way to know that the device addition is complete

def cp_rm_device():
    host = get_addr()
    path = '/'
    method = 'GET'
    headers = {'NT'       : 'upnp:rootdevice',
               'NTS'      : 'ssdp:byebye',
               'USN'      : 'abc'}
    httpmu_request(host, method, path, headers)
    time.sleep(1)
    #hack: there is no way to know that the device removal is complete

def msearch(st):
    host = get_addr()
    httpmu_request(host, 'M-SEARCH', '*',
                   headers = {'HOST' : '239.255.255.250:1900',
                              'MAN'  : '"ssdp:discover"',
                              'MX'   : '1',
                              'ST'   : st})
    time.sleep(1)
    #hack: should wait until ?

sync_string = '===SYNC==='
