#!/usr/bin/python

################################################
# UPnP NOTIFY Multicast Client Sender
# Rosfran Lins Borges (rosfran.borges@indt.org.br)
# multicast_socket_send_udp.py
################################################

import sys, traceback, os, socket, time
from utils import get_addrs
import urllib2
from ssdp_notify_msg import NotifyAliveMessageSession
from multicast_socket_send_udp import UDPSender

MAX_UDP_PACKETS_NUMBER = 30000
CRLF = '\r\n'

NT_DEFAULT = 'urn:schemas-upnp-org:device:InternetGatewayDevice:1'

# Declares UPnP NOTIFY UDP message
content_notify = [
 'NOTIFY * HTTP/1.1',
 'Server: BADANHA/201 UPnP/1.0 Product/1.1',
 'Cache-Control: max-age=%s',
 'Location: http://%s',
 'NTS: ssdp:alive',
 'NT: %s',
 'USN: uuid:a8e8276e-bcbd-bcba-abcd-1838ad8dc32a::%s',
 'HOST: %s:%s'
              ]
content_notify = "\r\n".join( content_notify )
content_notify += "\r\n\r\n"
# Finish declaration of the UPnP NOTIFY UDP message

content_msearch = 'M-SEARCH * HTTP/1.1'
CRLF
'HOST: 239.255.255.250:1900'
CRLF
'MAN: "ssdp:discover"'
CRLF
'MX: 10'
CRLF
'ST: %s'
CRLF

content_byebye = 'NOTIFY * HTTP/1.1'
CRLF
'HOST: 239.255.255.250:1900'
CRLF
'NT: "upnp:rootdevice"'
CRLF
'NTS: ssdp:byebye'
CRLF
'USN: %s'
CRLF

class UDPSendMsgSession:
    
    def send_notify_message(self, max_age, loc_host, def_nt, host, textport, max_packet_number = MAX_UDP_PACKETS_NUMBER):
        """Send a UPnP NOTIFY message with the configuration values obttained from the command line"""
        print "Parameters passed through this script (send_notify_message())= (%s) - %s\n" % (sys.argv, len(sys.argv))
    
        udpConn = UDPSender()
        udpConn.init_memory(host, textport)
        print "Host = %s, port = %s\n" % (host, textport)
        # parameters of the header LOCATION from the NOTIFY message (simulates a UPnP IGD Device)
        params = (max_age, loc_host, def_nt, def_nt, host, textport)
        print "Params = ", params
        for i in range(max_packet_number):
            print "UDP count = %d\n" % i
            #udpConn.connect_udp()
            udpConn.send_message(content_notify, params)
    
        # close multicast socket
        udpConn.close_mult_udp()
        print "Finished UPnP Notify (UDP) sending...\n"    
    
    def send_notify_message_from_file(self, notify_type, max_packet_number, host):
        """Send a UPnP NOTIFY message prepared from a configuration file"""
        #print "Parameters passed through this script (send_notify_message_from_file())= (%s) - %s\n" % (sys.argv, len(sys.argv))
        udpConn = UDPSender()
        udpConn.init_persistent(notify_type, host)
        #print "Sending multiple NOTIFYs to: Location= %s, Host = %s, port = %s\n" % (udpConn.notifySession.notifyMsg.get_location(), udpConn.udpHost, udpConn.udpPort)
        #print "UDP count: ",
        for i in range(max_packet_number):
            #print i,
            #print "UDP count = %d\n" % i
            #udpConn.connect_udp()
            udpConn.send_message_from_file()
            #print " - ",
    
        # close multicast socket
        udpConn.close_mult_udp()
        #print "\tFinished UPnP Notify (UDP) sending...\n"    

if __name__ == '__main__':
    udp_send_msgs_session = UDPSendMsgSession()
    
    if len(sys.argv) > 3:
        loc_host = '172.19.141.58:38400/description.xml'
        host = '239.255.255.250'
        textport = '1900'
        max_age = '1800'
        def_nt = NT_DEFAULT
        msg_ident = 'ssdp_alive'
        max_packet_number = MAX_UDP_PACKETS_NUMBER
        print "Parameters passed through this script = (%s) - %s\n" % (sys.argv, len(sys.argv))
        if len(sys.argv) > 1:
            print "Assigned host = %s\n" % host
            host = sys.argv[1]
            if len(sys.argv) > 2:
                print "Assigned port = %s\n" % textport
                textport = sys.argv[2]
            if len(sys.argv) > 3:
                print "Assigned maxAge = %s\n" % max_age
                max_age = sys.argv[3]
            if len(sys.argv) > 4:
                loc_host = sys.argv[4]
            if len(sys.argv) > 5:
                try:
                    max_packet_number = int(sys.argv[5])
                except ValueError:
                    print "Invalid conversion for the max packet number value: %d " % sys.argv[4]
                    sys.exit()
            if len(sys.argv) > 6:
                def_nt = sys.argv[6]
            if len(sys.argv) > 7:
                msg_ident = sys.argv[7]
            
            # calls the notify message
            udp_send_msgs_session.send_notify_message(max_age, loc_host, def_nt, host, textport, max_packet_number)
        else:
            print "\tUsage: %s [host] [port] [maxAge] [locHost] [maxPacketNumber] [NotificationType] [UDPmsgID]" % sys.argv[0]
    else:
        notify_type = ""
        max_packet_number = MAX_UDP_PACKETS_NUMBER
        if len(sys.argv) > 1:
            notify_type = sys.argv[1]
            if len(sys.argv) > 2:
                try:
                    max_packet_number = int(sys.argv[2])
                except ValueError:
                    print "Invalid conversion for the max packet number value: %d " % sys.argv[2]
                    sys.exit()
            udp_send_msgs_session.send_notify_message_from_file(notify_type, max_packet_number)
        else:
            print "\tUsage: %s [notify_type]" % sys.argv[0]
            
