#!/usr/bin/env python

################################################
# Simple UDP Multicast Server example
# Just listen for SSDP messages
# Rosfran Lins Borges (rosfran.borges@indt.org.br)
# multicast_with_twisted_server.py
################################################

from twisted.internet.protocol import DatagramProtocol
from twisted.internet import reactor
from twisted.application.internet import MulticastServer

class MulticastServerUDP(DatagramProtocol):
    def startProtocol(self):
        print 'Started Listening'
        # Join a specific multicast group, which is the IP we will respond to
        self.transport.joinGroup('239.255.255.250')

    def datagramReceived(self, datagram, address):
        # The uniqueID check is to ensure we only service requests from ourselves    
        print "Server Received: " + repr(datagram)
        self.transport.write("data", address)

# Note that the join function is picky about having a unique object
# on which to call join.  To avoid using startProtocol, the following is
# sufficient:
#reactor.listenMulticast(1900, MulticastServerUDP()).join('239.255.255.250')

if __name__ == "__main__":
    try:
        # Listen for multicast on 239.255.255.250:1900
        reactor.listenMulticast(1900, MulticastServerUDP())
        reactor.run()
    except (KeyboardInterrupt, SystemExit):
        sys.exit(1)
