/**
 *
 * 	UPnP IGD device implementation, with more nested embedded sub-devices
 */

#include <cybergarage/upnp/cupnp.h>
#include "common.h"

char *IGD_DEVICE_DESCRIPTION_FILE_NAME = "igddescs/gatedesc.xml";
char *IGD_ICFG_SERVICE_DESCRIPTION_FILE_NAME = "igddescs/gateifcgSCPD.xml";
char *IGD_CONN_SERVICE_DESCRIPTION_FILE_NAME = "igddescs/gateconnSCPD.xml";

/**
 * UPnP IGD device description
 */
char *IGD_DEVICE_DESCRIPTION =
"<?xml version=\"1.0\"?>"
"<root xmlns=\"urn:schemas-upnp-org:device-1-0\">"
"	<specVersion>"
"		<major>1</major>"
"		<minor>0</minor>"
"	</specVersion>"
"	<device>"
"		<deviceType>urn:schemas-upnp-org:device:InternetGatewayDevice:1</deviceType>"
"		<friendlyName>UPnPIGD</friendlyName>"
"		<manufacturer>Linux UPnP IGD Project</manufacturer>"
"		<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"		<modelName>IGD Version 0.92</modelName>"
"		<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"		<iconList>"
"			<icon>"
"				<mimetype>image/gif</mimetype>"
"				<width>118</width>"
"				<height>119</height>"
"				<depth>8</depth>"
"				<url>/ligd.gif</url>"
"			</icon>"
"		</iconList>"
"		<serviceList>"
"       	<service>"
"           	<serviceType>urn:schemas-dummy-com:service:Dummy:1</serviceType>"
"               <serviceId>urn:dummy-com:serviceId:dummy1</serviceId>"
"	            <controlURL>/dummy</controlURL>"
"               <eventSubURL>/dummy</eventSubURL>"
"       		<SCPDURL>/igddescs/dummy.xml</SCPDURL>"
"           </service>"
"       </serviceList>"
"		<deviceList>"
"			<device>"
"				<deviceType>urn:schemas-upnp-org:device:WANDevice:1</deviceType>"
"				<friendlyName>WANDevice</friendlyName>"
"				<manufacturer>Linux UPnP IGD Project</manufacturer>"
"				<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"				<modelDescription>WAN Device on Linux IGD</modelDescription>"
"				<modelName>Linux IGD</modelName>"
"				<modelNumber>0.92</modelNumber>"
"				<modelURL>http://linux-igd.sourceforge.net</modelURL>"
"				<serialNumber>0.92</serialNumber>"
"				<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"				<UPC>Linux IGD</UPC>"
"				<serviceList>"
"					<service>"
"						<serviceType>urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1</serviceType>"
"						<serviceId>urn:upnp-org:serviceId:WANCommonIFC1</serviceId>"
"						<controlURL>/upnp/control/WANCommonIFC1</controlURL>"
"						<eventSubURL>/upnp/control/WANCommonIFC1</eventSubURL>"
"						<SCPDURL>/igddescs/gateicfgSCPD.xml</SCPDURL>"
"					</service>"
"				</serviceList>"
"				<deviceList>"
"					<device>"
"						<deviceType>urn:schemas-upnp-org:device:WANConnectionDevice:1</deviceType>"
"						<friendlyName>WANConnectionDevice</friendlyName>"
"						<manufacturer>Linux UPnP IGD Project</manufacturer>"
"						<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"						<modelDescription>WanConnectionDevice on Linux IGD</modelDescription>"
"						<modelName>Linux IGD</modelName>"
"						<modelNumber>0.92</modelNumber>"
"						<modelURL>http://linux-igd.sourceforge.net</modelURL>"
"						<serialNumber>0.92</serialNumber>"
"						<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"						<UPC>Linux IGD</UPC>"
"						<serviceList>"
"							<service>"
"								<serviceType>urn:schemas-upnp-org:service:WANIPConnection:1</serviceType>"
"								<serviceId>urn:upnp-org:serviceId:WANIPConn1</serviceId>"
"								<controlURL>/upnp/control/WANIPConn1</controlURL>"
"								<eventSubURL>/upnp/control/WANIPConn1</eventSubURL>"
"								<SCPDURL>/igddescs/gateconnSCPD.xml</SCPDURL>"
"							</service>"
"						</serviceList>"
"						<deviceList>"
"							<device>"
"								<deviceType>urn:schemas-upnp-org:device:WAN222ConnectionDevice:1</deviceType>"
"								<friendlyName>WAN222ConnectionDevice</friendlyName>"
"								<manufacturer>Linux UPnP IGD Project</manufacturer>"
"								<manufacturerURL>http://linux-igd.sourceforge.net</manufacturerURL>"
"								<modelDescription>WAN222ConnectionDevice on Linux IGD</modelDescription>"
"								<modelName>Linux IGD</modelName>"
"								<modelNumber>0.92</modelNumber>"
"								<modelURL>http://linux-igd.sourceforge.net</modelURL>"
"								<serialNumber>0.92</serialNumber>"
"								<UDN>uuid:75802409-bccb-40e7-8e6c-fa095ecce13e</UDN>"
"								<UPC>Linux IGD</UPC>"
"								<serviceList>"
"									<service>"
"										<serviceType>urn:schemas-upnp-org:service:WAN222IPConnection:1</serviceType>"
"										<serviceId>urn:upnp-org:serviceId:WAN222IPConn1</serviceId>"
"										<controlURL>/upnp/control/WAN222IPConn1</controlURL>"
"										<eventSubURL>/upnp/control/WAN222IPConn1</eventSubURL>"
"										<SCPDURL>/igddescs/gateconnSCPD.xml</SCPDURL>"
"									</service>"
"								</serviceList>"
"							</device>"
"						</deviceList>"
"					</device>"
"				</deviceList>"
"			</device>"
"		</deviceList>"
"	</device>"
"</root>";

/**
 * UPnP IGD Common Interface Config service description
 */
char *IGD_IFCG_SERVICE_DESCRIPTION =
"<?xml version=\"1.0\"?>"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">"
"	<specVersion>"
"		<major>1</major>"
"		<minor>0</minor>"
"	</specVersion>"
"	<actionList>"
"    <action>"
"      <name>GetCommonLinkProperties</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewWANAccessType</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>WANAccessType</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLayer1UpstreamMaxBitRate</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>Layer1UpstreamMaxBitRate</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLayer1DownstreamMaxBitRate</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>Layer1DownstreamMaxBitRate</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewPhysicalLinkStatus</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PhysicalLinkStatus</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalBytesSent</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalBytesSent</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>TotalBytesSent</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalBytesReceived</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalBytesReceived</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>TotalBytesReceived</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalPacketsSent</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalPacketsSent</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>TotalPacketsSent</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetTotalPacketsReceived</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewTotalPacketsReceived</name>"
"          <direction>out</direction>"
"         <relatedStateVariable>TotalPacketsReceived</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"	</actionList>"
"	<serviceStateTable>"
"		<stateVariable sendEvents=\"no\">"
"			<name>WANAccessType</name>"
"			<dataType>string</dataType>"
"			<allowedValueList>"
"				<allowedValue>DSL</allowedValue>"
"				<allowedValue>POTS</allowedValue>"
"				<allowedValue>Cable</allowedValue>"
"				<allowedValue>Ethernet</allowedValue>"
"				<allowedValue>Other</allowedValue>"
"			</allowedValueList>"
"		</stateVariable>"
"		<stateVariable sendEvents=\"no\">"
"			<name>Layer1UpstreamMaxBitRate</name>"
"			<dataType>ui4</dataType>"
"		</stateVariable>"
"		<stateVariable sendEvents=\"no\">"
"			<name>Layer1DownstreamMaxBitRate</name>"
"			<dataType>ui4</dataType>"
"		</stateVariable>"
"		<stateVariable sendEvents=\"yes\">"
"			<name>PhysicalLinkStatus</name>"
"			<dataType>string</dataType>"
"	  <allowedValueList>"
"        <allowedValue>Up</allowedValue>"
"        <allowedValue>Down</allowedValue>"
"        <allowedValue>Initializing</allowedValue>"
"        <allowedValue>Unavailable</allowedValue>"
"      </allowedValueList>"
"		</stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>WANAccessProvider</name>"
"      <dataType>string</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>MaximumActiveConnections</name>"
"      <dataType>ui2</dataType>"
"      <allowedValueRange>"
"        <minimum>1</minimum>"
"        <maximum></maximum>"
"        <step>1</step>"
"      </allowedValueRange>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalBytesSent</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalBytesReceived</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalPacketsSent</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>TotalPacketsReceived</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"	</serviceStateTable>"
"</scpd>";

/**
 * UPnP IGD IP Connection service description
 */
char *IGD_CONN_SERVICE_DESCRIPTION =
"<?xml version=\"1.0\"?>"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">"
"  <specVersion>"
"    <major>1</major>"
"    <minor>0</minor>"
"  </specVersion>"
"  <actionList>"
"    <action>"
"      <name>SetConnectionType</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewConnectionType</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>ConnectionType</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetConnectionTypeInfo</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewConnectionType</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>ConnectionType</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewPossibleConnectionTypes</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PossibleConnectionTypes</relatedStateVariable>"
"       </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"      <name>RequestConnection</name>"
"    </action>"
"    <action>"
"      <name>ForceTermination</name>"
"    </action>"
"    <action>"
"     <name>GetStatusInfo</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewConnectionStatus</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>ConnectionStatus</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLastConnectionError</name>"
"		  <direction>out</direction>"
"          <relatedStateVariable>LastConnectionError</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewUptime</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>Uptime</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"      <name>GetNATRSIPStatus</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewRSIPAvailable</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>RSIPAvailable</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewNATEnabled</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>NATEnabled</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"      <name>GetGenericPortMappingEntry</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewPortMappingIndex</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingNumberOfEntries</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewRemoteHost</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>RemoteHost</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewExternalPort</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>ExternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewProtocol</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingProtocol</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewInternalPort</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>InternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewInternalClient</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>InternalClient</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewEnabled</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingEnabled</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewPortMappingDescription</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingDescription</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLeaseDuration</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingLeaseDuration</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"   </action>"
"    <action>"
"      <name>GetSpecificPortMappingEntry</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewRemoteHost</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>RemoteHost</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewExternalPort</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>ExternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewProtocol</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingProtocol</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewInternalPort</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>InternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewInternalClient</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>InternalClient</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewEnabled</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingEnabled</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewPortMappingDescription</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingDescription</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewLeaseDuration</name>"
"          <direction>out</direction>"
"          <relatedStateVariable>PortMappingLeaseDuration</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"      <name>AddPortMapping</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewRemoteHost</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>RemoteHost</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewExternalPort</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>ExternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewProtocol</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingProtocol</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewInternalPort</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>InternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewInternalClient</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>InternalClient</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewEnabled</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingEnabled</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewPortMappingDescription</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingDescription</relatedStateVariable>"
"        </argument>"
"       <argument>"
"          <name>NewLeaseDuration</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingLeaseDuration</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"      <name>DeletePortMapping</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewRemoteHost</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>RemoteHost</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewExternalPort</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>ExternalPort</relatedStateVariable>"
"        </argument>"
"        <argument>"
"          <name>NewProtocol</name>"
"          <direction>in</direction>"
"          <relatedStateVariable>PortMappingProtocol</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"    <action>"
"    <name>GetExternalIPAddress</name>"
"      <argumentList>"
"        <argument>"
"          <name>NewExternalIPAddress</name>"
"          <direction>out</direction>"
"        <relatedStateVariable>ExternalIPAddress</relatedStateVariable>"
"        </argument>"
"      </argumentList>"
"    </action>"
"  </actionList>"
"  <serviceStateTable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>ConnectionType</name>"
"      <dataType>string</dataType>"
"      <defaultValue>Unconfigured</defaultValue>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"yes\">"
"      <name>PossibleConnectionTypes</name>"
"      <dataType>string</dataType>"
"      <allowedValueList>"
"        <allowedValue>Unconfigured</allowedValue>"
"        <allowedValue>IP_Routed</allowedValue>"
"        <allowedValue>IP_Bridged</allowedValue>"
"      </allowedValueList>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"yes\">"
"      <name>ConnectionStatus</name>"
"      <dataType>string</dataType>"
"      <defaultValue>Unconfigured</defaultValue>"
"      <allowedValueList>"
"        <allowedValue>Unconfigured</allowedValue>"
"    	  <allowedValue>Connecting</allowedValue>"
"    	  <allowedValue>Authenticating</allowedValue>"
"        <allowedValue>PendingDisconnect</allowedValue>"
"        <allowedValue>Disconnecting</allowedValue>"
"        <allowedValue>Disconnected</allowedValue>"
"        <allowedValue>Connected</allowedValue>"
"      </allowedValueList>"
"   </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>Uptime</name>"
"      <dataType>ui4</dataType>"
"      <defaultValue>0</defaultValue>"
"      <allowedValueRange>"
"        <minimum>0</minimum>"
"        <maximum></maximum>"
"        <step>1</step>"
"      </allowedValueRange>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>RSIPAvailable</name>"
"      <dataType>boolean</dataType>"
"      <defaultValue>0</defaultValue>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>NATEnabled</name>"
"      <dataType>boolean</dataType>"
"      <defaultValue>1</defaultValue>"
"    </stateVariable>  "
"    <stateVariable sendEvents=\"no\">"
"      <name>LastConnectionError</name>"
"      <dataType>string</dataType>"
"      <defaultValue>ERROR_NONE</defaultValue>"
"      <allowedValueList>"
"        <allowedValue>ERROR_NONE</allowedValue>"
"      	 <allowedValue>ERROR_ISP_TIME_OUT</allowedValue>"
"        <allowedValue>ERROR_COMMAND_ABORTED</allowedValue>"
"        <allowedValue>ERROR_NOT_ENABLED_FOR_INTERNET</allowedValue>"
"        <allowedValue>ERROR_BAD_PHONE_NUMBER</allowedValue>"
"        <allowedValue>ERROR_USER_DISCONNECT</allowedValue>"
"        <allowedValue>ERROR_ISP_DISCONNECT</allowedValue>"
"        <allowedValue>ERROR_IDLE_DISCONNECT</allowedValue>"
"        <allowedValue>ERROR_FORCED_DISCONNECT</allowedValue>"
"        <allowedValue>ERROR_SERVER_OUT_OF_RESOURCES</allowedValue>"
"        <allowedValue>ERROR_RESTRICTED_LOGON_HOURS</allowedValue>"
"        <allowedValue>ERROR_ACCOUNT_DISABLED</allowedValue>"
"        <allowedValue>ERROR_ACCOUNT_EXPIRED</allowedValue>"
"        <allowedValue>ERROR_PASSWORD_EXPIRED</allowedValue>"
"        <allowedValue>ERROR_AUTHENTICATION_FAILURE</allowedValue>"
"        <allowedValue>ERROR_NO_DIALTONE</allowedValue>"
"        <allowedValue>ERROR_NO_CARRIER</allowedValue>"
"        <allowedValue>ERROR_NO_ANSWER</allowedValue>"
"	    <allowedValue>ERROR_LINE_BUSY</allowedValue>"
"	    <allowedValue>ERROR_UNSUPPORTED_BITSPERSECOND</allowedValue>"
"	    <allowedValue>ERROR_TOO_MANY_LINE_ERRORS</allowedValue>"
"	    <allowedValue>ERROR_IP_CONFIGURATION</allowedValue>"
"	    <allowedValue>ERROR_UNKNOWN</allowedValue>"
"      </allowedValueList>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"yes\">"
"      <name>ExternalIPAddress</name>"
"      <dataType>string</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>RemoteHost</name>"
"      <dataType>string</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>ExternalPort</name>"
"      <dataType>ui2</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>InternalPort</name>"
"      <dataType>ui2</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>PortMappingProtocol</name>"
"      <dataType>string</dataType>"
"      <allowedValueList>"
"        <allowedValue>TCP</allowedValue>"
"        <allowedValue>UDP</allowedValue>"
"      </allowedValueList>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>InternalClient</name>"
"      <dataType>string</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>PortMappingDescription</name>"
"      <dataType>string</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>PortMappingEnabled</name>"
"      <dataType>boolean</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"no\">"
"      <name>PortMappingLeaseDuration</name>"
"      <dataType>ui4</dataType>"
"    </stateVariable>"
"    <stateVariable sendEvents=\"yes\">"
"      <name>PortMappingNumberOfEntries</name>"
"      <dataType>ui2</dataType>"
"    </stateVariable>"
"  </serviceStateTable>"
"</scpd>";

/**
 * Action listener for WAN Common Interface Config service 
 * Just see if the action is conformant with any service, in any IGD embedded device
 */
BOOL upnp_igd_common_ifcg_actionreceived(CgUpnpAction *action)
{
	char *actionName;
	CgUpnpService* service;

	actionName = cg_upnp_action_getname(action);
	service = cg_upnp_action_getservice(action);
	if (cg_strcmp(cg_upnp_service_getserviceid(service), "urn:upnp-org:serviceId:WANCommonIFC1") == 0) {
		if (cg_strcmp(actionName,"GetCommonLinkProperties") == 0)
			return TRUE;
		else if (cg_strcmp(actionName,"GetTotalBytesReceived") == 0)
			return TRUE;
		else return FALSE;
	}

	return FALSE;
}


/**
 * upnp_igd_device_new
 */
CgUpnpDevice *upnp_igd_device_new(int leaseTime)
{
	CgUpnpDevice *igdDev, *wanDev, *wanConnDev, *dev;
	CgUpnpDevice* wanConn222Dev;
	CgUpnpDeviceList* devsList;	
	
	CgUpnpServiceList* servsList;	
	CgUpnpService *wanConfigService;
	CgUpnpService *wanIPConnService;
	CgUpnpService *serv;
	CgUpnpService* wanIPConn222Service;
	
	CgUpnpActionList* actionList;
	CgUpnpActionList* action;
	
	int i;
	
	CgString *descURI = cg_string_new();
	cg_string_setvalue( descURI, "/" );
	cg_string_addvalue( descURI, IGD_DEVICE_DESCRIPTION_FILE_NAME );
	
	igdDev = cg_upnp_device_new();
	cg_upnp_device_setdescriptionuri( igdDev, cg_string_getvalue(descURI) );
	cg_string_delete(descURI);
	cg_upnp_device_setleasetime(igdDev, leaseTime);

	if (cg_upnp_device_parsedescription(igdDev, IGD_DEVICE_DESCRIPTION, cg_strlen(IGD_DEVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_device_delete(igdDev);
		return NULL;
	}
	
	/* get the WANDevice child-device, from the IGD Device root node */
	wanDev = cg_upnp_device_getdevicebyexacttype(igdDev, "urn:schemas-upnp-org:device:WANDevice:1");
	
	/* get the WAN Common Interface Config service, from WANDevice */
	wanConfigService = cg_upnp_device_getservicebyserviceid(wanDev, "urn:upnp-org:serviceId:WANCommonIFC1");
	if (cg_upnp_service_parsedescription(wanConfigService, IGD_IFCG_SERVICE_DESCRIPTION, cg_strlen(IGD_IFCG_SERVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_service_delete(wanConfigService);
		return NULL;
	}
	
	/* get the WANConnectionDevice subchild-device, from the IGD-child WANDevice root node */
	wanConnDev = cg_upnp_device_getdevicebyexacttype(wanDev, "urn:schemas-upnp-org:device:WANConnectionDevice:1");
	
	wanIPConnService = cg_upnp_device_getservicebyserviceid(wanConnDev, "urn:upnp-org:serviceId:WANIPConn1");
	if (cg_upnp_service_parsedescription(wanIPConnService, IGD_CONN_SERVICE_DESCRIPTION, cg_strlen(IGD_CONN_SERVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_service_delete(wanIPConnService);
		return NULL;
	}
	
	actionList = cg_upnp_service_getactionlist(wanIPConnService);
	fprintf( stderr, "Action-list from the service %s...\n", cg_upnp_service_getserviceid(wanIPConnService) );
	for ( action = cg_upnp_actionlist_gets(actionList); action; action = cg_upnp_action_next(action) ) {
		fprintf( stderr, "\tService %s, action %s\n", cg_upnp_service_getserviceid(wanIPConnService), 
			cg_upnp_action_getname(action) );
	}
	
	/* get the WAN222ConnectionDevice subchild-device, from the IGD-child WANConnDevice root node */
	wanConn222Dev = cg_upnp_device_getdevicebyexacttype(wanConnDev, "urn:schemas-upnp-org:device:WAN222ConnectionDevice:1");
	
	wanIPConn222Service = cg_upnp_device_getservicebyserviceid(wanConn222Dev, "urn:upnp-org:serviceId:WAN222IPConn1");
	if (cg_upnp_service_parsedescription(wanIPConn222Service, IGD_CONN_SERVICE_DESCRIPTION, cg_strlen(IGD_CONN_SERVICE_DESCRIPTION)) == FALSE) {
		cg_upnp_service_delete(wanIPConn222Service);
		return NULL;
	}

	cg_upnp_service_setactionlistener(wanConfigService, upnp_igd_common_ifcg_actionreceived);

	return igdDev;
}

int main( int argc, char* argv[] )
{
	int leaseTime = 1800;
	CgUpnpDevice *igdDev = upnp_igd_device_new(leaseTime);
	
	if ( igdDev != NULL ) {
		if ( !cg_upnp_device_start(igdDev) ) {
			fprintf( stderr, "IGD Device (modified with multiple sub-devices) couldn't be started!\n" );
		} else {
			fprintf( stderr, "IGD Device (modified with multiple sub-devices) started!\n" );
		}
	}
	
	printf(SYNC_STRING);
	fflush(NULL);
	getchar();	

	cg_upnp_device_stop(igdDev);
	cg_upnp_device_delete(igdDev);

	return(0);
}
