/************************************************************
*
*	CyberLink for C
*
*	Copyright (C) Satoshi Konno 2005
*
*	File: clock_main.c
*
*	Revision:
*       05/11/05
*               - first release.
*
************************************************************/

#include <cybergarage/upnp/cupnp.h>

#include "clock_device.h"

#if defined(TENGINE)
#if defined(PROCESS_BASE) /* Process based */
#include <basic.h>
#define MBEG	int main( W ac, TC *av[] )
#define MEND	0
#define DIR	"/SYS/bin/"
#else /* T-Kernel based */
#include <basic.h>
#include <tk/tkernel.h>
#include <sys/pinfo.h>
#define MBEG	ER main( INT ac, UB *av[] )
#define MEND	E_SYS
#define DIR	"/SYS/bin/"
#endif
#endif

CgUpnpDevice *finnishClock = NULL;
long finnishOffset = 0;
CgUpnpDevice *swedishClock = NULL;
long swedishOffset = -3600;
CgUpnpDevice *utcClock = NULL;
long utcOffset = -7200;

////////////////////////////////////////////////////////// 
//  InitApp
////////////////////////////////////////////////////////// 

BOOL InitApp( int cacheControl )
{
	finnishClock = upnp_clock_device_new( (void*) &finnishOffset, "finnish.xml", "urn:schemas-upnp-org:service:finnishtimer:1", "urn:schemas-upnp-org:service:finnishembeddedtimer1:1" );
        if ( finnishClock == NULL ) {
                printf( "Finnish upnp_clock_device_new() failed\n" );
                return FALSE;
        }
        cg_upnp_device_setleasetime(finnishClock, cacheControl);
	if ( cg_upnp_device_start(finnishClock) == FALSE )
                return FALSE;
        
	swedishClock = upnp_clock_device_new( (void*) &swedishOffset, "swedish.xml", "urn:schemas-upnp-org:service:swedishtimer:1", "urn:schemas-upnp-org:service:swedishembeddedtimer1:1" );
        if ( swedishClock == NULL ) {
                printf( "Swedish upnp_clock_device_new() failed\n" );
                return FALSE;
        }
        cg_upnp_device_setleasetime(swedishClock, cacheControl);
        if ( cg_upnp_device_sethttpport(swedishClock, 38401) == FALSE ) {
                printf( "http port open failed\n" );
                return FALSE;
        }
	if ( cg_upnp_device_start(swedishClock) == FALSE ) {
                printf( "Swedish clock start failed\n" );
                return FALSE;
        }

	utcClock = upnp_clock_device_new( (void*) &utcOffset, "utc.xml", "urn:schemas-upnp-org:service:utctimer:1", "urn:schemas-upnp-org:service:utcembeddedtimer1:1" );
        if ( utcClock == NULL ) {
                printf( "utc upnp_clock_device_new() failed\n" );
                return FALSE;
        }
        cg_upnp_device_setleasetime(utcClock, cacheControl);
        if ( cg_upnp_device_sethttpport(utcClock, 38401) == FALSE ) {
                printf( "http port open failed\n" );
                return FALSE;
        }
	if ( cg_upnp_device_start(utcClock) == FALSE ) {
                printf( "utc clock start failed\n" );
                return FALSE;
        }

        return TRUE;
}

void ExitApp()
{
        if ( finnishClock != NULL ) {
                cg_upnp_device_stop(finnishClock);
                cg_upnp_device_delete(finnishClock);
        }

        if ( swedishClock != NULL ) {
                cg_upnp_device_stop(swedishClock);
                cg_upnp_device_delete(swedishClock);
        }

	if ( utcClock != NULL )
	{
		cg_upnp_device_stop(utcClock);
		cg_upnp_device_delete(utcClock);
	}

}

////////////////////////////////////////////////////////// 
//  main
////////////////////////////////////////////////////////// 

#if defined(TENGINE)
MBEG
#else
int main( int argc, char* argv[] )
#endif
{
        int cacheControl = -1;

        if ( argc == 1 ) {
                printf( "usage: clock [cache_control_in_sec]\n" );
                cacheControl = 1800;
        }
        else if ( argc > 2 ) {
                printf( "usage: clock [cache_control_in_sec]\n" );
                exit( 0 );
        }
        else if (sscanf(argv[1], "%i", &cacheControl) != 1) {
                printf( "Invalid CACHE-CONTROL value.\n" );
                exit( 0 );
        }

        printf( "Using CACHE-CONTROL value: %d sec\n", cacheControl );

	if (InitApp( cacheControl ) == FALSE) {
		fprintf(stderr, "Couldn't create the clock devices!!\n");
		exit(0);
	}
				
	int ch = 0;

        printf( "Press 1 - Enter to generate a Finnish clock event.\n" );
        printf( "Press 2 - Enter to generate a Swedish clock event.\n" );
	printf( "Press 3 - Enter to generate an UTC clock event.\n" );
        printf( "Press q - Enter to quit.\n" );

        upnp_clock_device_update(finnishClock, "urn:schemas-upnp-org:service:finnishtimer:1");
        upnp_clock_device_update(swedishClock, "urn:schemas-upnp-org:service:swedishtimer:1");
	upnp_clock_device_update(utcClock, "urn:schemas-upnp-org:service:utctimer:1");

        ch = getchar();
        while ( ch != 'q' ) {
                if ( ch == '1' ) {
                        upnp_clock_device_update(finnishClock, "urn:schemas-upnp-org:service:finnishtimer:1");
                }
                else if ( ch == '2' ) {
                        upnp_clock_device_update(swedishClock, "urn:schemas-upnp-org:service:swedishtimer:1");
                }
		else if ( ch == '3' ) {
			upnp_clock_device_update(utcClock, "urn:schemas-upnp-org:service:utctimer:1");
		}
		
                ch = getchar();
	};

	ExitApp();
	
	return(0);
}
