/************************************************************
*
*	CyberLink for C
*
*	Copyright (C) Satoshi Konno 2005
*
*	File: clock_device.c
*
*	Revision:
*       05/11/05
*               - first release.
*
*	10/31/05
*		- Removed :schemas: from clock service description
*
************************************************************/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "clock_device.h"
#include "clock.h"

#include <string.h>


/****************************************
* upnp_clock_actionreceived
****************************************/

BOOL upnp_clock_actionreceived(CgUpnpAction *action)
{
	CgSysTime currTime;
	char *actionName;
	CgUpnpArgument *currTimeArg;
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	CgUpnpArgument *newTimeArg, *resultArg;

	currTime = cg_getcurrentsystemtime();
	
	actionName = cg_upnp_action_getname(action);
	if (strcmp("GetTime", actionName) == 0) {
		GetSystemTimeString(currTime, sysTimeStr);
		currTimeArg = cg_upnp_action_getargumentbyname(action, "CurrentTime");
		cg_upnp_argument_setvalue(currTimeArg, sysTimeStr);
		return TRUE;
	}
	if (strcmp("SomeActionWhichGeneratesAnError", actionName) == 0) {
		cg_upnp_action_setstatuscode(action, 854);
		cg_upnp_action_setstatusdescription(action, "A non-standard error");
		return FALSE;
	}
	if (strcmp(actionName, "SetTime") == 0) {
		newTimeArg = cg_upnp_action_getargumentbyname(action, "NewTime");
		resultArg = cg_upnp_action_getargumentbyname(action, "Result");
		cg_upnp_argument_setvalue(resultArg, "Not implemented");
		return TRUE;
	}

	return FALSE;
}

/****************************************
* upnp_clock_queryreceived
****************************************/

BOOL upnp_clock_queryreceived(CgUpnpStateVariable *statVar)
{
	char *varName;
	CgSysTime currTime;
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	
	varName = cg_upnp_statevariable_getname(statVar);
	if (strcmp("Time", varName) == 0) {
		currTime = cg_getcurrentsystemtime();
		GetSystemTimeString(currTime, sysTimeStr);
		cg_upnp_statevariable_setvalue(statVar, sysTimeStr);
		return TRUE;
	}
	
	return FALSE;
}

/****************************************
* upnp_clock_device_httprequestrecieved
****************************************/

void upnp_clock_device_httprequestrecieved(CgHttpRequest *httpReq)
{
	CgSysTime currTime;
	CgUpnpDevice *dev;
	char *uri;
	char content[2048];
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	char serverName[CG_UPNP_SEVERNAME_MAXLEN];
	CgHttpResponse *httpRes;
	BOOL postRet;
	
	dev = (CgUpnpDevice *)cg_http_request_getuserdata(httpReq);

	uri = cg_http_request_geturi(httpReq);
	if (strcmp(uri, "/presentation") != 0) {
		cg_upnp_device_httprequestrecieved(httpReq);
		return;
	}

	currTime = cg_getcurrentsystemtime();

#if defined(HAVE_SNPRINTF)
	snprintf(content, sizeof(content),
#else
	sprintf(content,
#endif
		"<HTML>"
		"<HEAD>"
		"<TITLE>UPnP Clock Sample</TITLE>"
		"</HEAD>"
		"<META HTTP-EQUIV=\"Refresh\" CONTENT=\"1; URL=/presentation\">"
		"<BODY><CENTER>"
		"<H1>UPnP Clock Sample</H1>"
		"<TABLE border=\"0\" cellpadding=\"0\" cellspacing=\"0\">"
		"<TR>"
		"<TD style=\"width: 50px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"width: 50px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"<TR>"
		"<TD style=\"height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"height: 50px; background-color: rgb(221, 236, 245);\" align=\"center\"><H1>"
		"%s"
		"</H1></TD>"
		"<TD style=\"height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"<TR>"
		"<TD style=\"height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"height: 50px; background-color: rgb(221, 236, 245);\" align=\"center\"><H3>"
		"Server : %s"
		"</H3></TD>"
		"<TD style=\"height: 30px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"<TR>"
		"<TD style=\"width: 30px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"background-color: rgb(176, 176, 176);\"></TD>"
		"<TD style=\"width: 30px; height: 50px; background-color: rgb(176, 176, 176);\"></TD>"
		"</TR>"
		"</TABLE>"
		"<CENTER></BODY>"
		"</HTML>",
		GetSystemTimeString(currTime, sysTimeStr),
		cg_upnp_getservername(serverName, sizeof(serverName)));

	httpRes = cg_http_response_new();
	cg_http_response_setstatuscode(httpRes, CG_HTTP_STATUS_OK);
	cg_http_response_setcontent(httpRes, content);
	cg_http_response_setcontenttype(httpRes, "text/html");
	cg_http_response_setcontentlength(httpRes, strlen(content));
	postRet = cg_http_request_postresponse(httpReq, httpRes);
	cg_http_response_delete(httpRes);
}

/****************************************
* upnp_clock_device_new
****************************************/

CgUpnpDevice *upnp_clock_device_new( char *descrFileName, char *srvName, char *srvDescr )
{
	CgUpnpDevice *clockDev;
	CgUpnpService *timeService;
	 
	clockDev = cg_upnp_device_new();

	if ( cg_upnp_device_loaddescriptionfile(clockDev, descrFileName) == FALSE ) {
                printf( "cg_upnp_device_loaddescriptionfile() failed\n" );
		cg_upnp_device_delete(clockDev);
		return NULL;
	}

	timeService = cg_upnp_device_getservicebyexacttype(clockDev, srvName);
	if (timeService == NULL) {
                printf( "cg_upnp_device_getservicebyexacttype(clockDev, %s) failed\n", srvName );
		cg_upnp_device_delete(clockDev);
		return NULL;
	}
	
	printf("Service description:\n");
	printf("%s\n", srvDescr);
	if (cg_upnp_service_parsedescription(timeService, srvDescr, strlen(srvDescr)) == FALSE) {
		cg_upnp_device_delete(clockDev);
                printf( "Failed to parse this:\n%s\n", srvDescr );
		return NULL;
	}

	cg_upnp_device_setactionlistener(clockDev, upnp_clock_actionreceived);
	cg_upnp_device_setquerylistener(clockDev, upnp_clock_queryreceived);
	cg_upnp_device_sethttplistener(clockDev, upnp_clock_device_httprequestrecieved);

	return clockDev;
}

/****************************************
* upnp_clock_device_update
****************************************/

void upnp_clock_device_update(CgUpnpDevice *clockDev)
{
	CgSysTime currTime;
	CgUpnpService *timeService;
	CgUpnpStateVariable *timeState;
	char sysTimeStr[SYSTEM_TIME_BUF_LEN];
	
	timeService = cg_upnp_device_getservicebyexacttype(clockDev, "urn:schemas-upnp-org:service:timer:1");
	if (timeService == NULL)
		return;

	timeState = cg_upnp_service_getstatevariablebyname(timeService, "Time");
	if (timeState == NULL)
		return;
	
	currTime = cg_getcurrentsystemtime();
	GetSystemTimeString(currTime, sysTimeStr);
	cg_upnp_statevariable_setvalue(timeState, sysTimeStr);

        printf("%s\n", sysTimeStr);
}

