/*
 * $RCSId: xc/programs/Xserver/hw/kdrive/linux/tslib.c,v 1.1 2002/11/01 22:27:49 keithp Exp $
 * TSLIB based touchscreen driver for TinyX
 * Derived from ts.c by Keith Packard
 * Derived from ps2.c by Jim Gettys
 *
 * Copyright  1999 Keith Packard
 * Copyright  2000 Compaq Computer Corporation
 * Copyright  2002 MontaVista Software Inc.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard or Compaq not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard and Compaq makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD AND COMPAQ DISCLAIM ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Michael Taht or MontaVista not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Michael Taht and Montavista make no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * MICHAEL TAHT AND MONTAVISTA DISCLAIM ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL EITHER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#define NEED_EVENTS
#include <X11/X.h>
#include <X11/Xproto.h>
#include <X11/Xpoll.h>
#include "inputstr.h"
#include "scrnintstr.h"
#include "kdrive.h"
#include <sys/ioctl.h>
#include <tslib.h>

#define TSLIB_QUEUE_SIZE 3

#define DebugF(...) /* */

static long lastx = 0, lasty = 0;
static struct tsdev *tsDev = NULL;
static int numHeldEvents = 0, holdEvents = 1;
static struct {
    int x;
    int y;
    int z;
    int flags;
} heldEvent[3];
int lastFlags;

void (*tslib_raw_event_hook)(int x, int y, int pressure, void *closure);
void *tslib_raw_event_closure;

unsigned int THUMB_PRESSURE = 115;

int KdTsPhyScreen = 0;

static void
TsRead (int tsPort, void *closure)
{
    KdMouseInfo	    *mi = closure;
    struct ts_sample event;
    int		    postx, posty, discard, i;
    long	    x, y;
    unsigned long   flags;

    if (tslib_raw_event_hook) {
        if (ts_read_raw(tsDev, &event, 1) == 1)
            tslib_raw_event_hook (event.x, event.y, event.pressure, tslib_raw_event_closure);
        return;
      }

    while (ts_read(tsDev, &event, 1) == 1) {
        discard = 0;

	if (event.pressure) {
            if (event.pressure > THUMB_PRESSURE)
                flags = KD_BUTTON_8;
            else
                flags = KD_BUTTON_1;

            /*
             * Here we test for the touch screen driver actually being on the
             * touch screen, if it is we send absolute coordinates. If not,
             * then we send delta's so that we can track the entire vga screen.
             */
            if (KdCurScreen == KdTsPhyScreen) {
                x = event.x;
                y = event.y;
            }
            else {
                flags |= KD_MOUSE_DELTA;
                if ((lastx == 0) || (lasty == 0)) {
                    x = event.x;
                    y = event.y;
                }
                else {
                    x = event.x - lastx;
                    y = event.y - lasty;
                }
            }
            lastx = x;
            lasty = y;
	}
        else {
            flags = 0;
            x = lastx;
            y = lasty;
	}
        if (flags & (KD_BUTTON_1 | KD_BUTTON_8) && holdEvents) {
            if (numHeldEvents >= TSLIB_QUEUE_SIZE) {
                miPointerPosition(&postx, &posty);
                if (abs(postx - heldEvent[numHeldEvents - 1].x) < 4 &&
                    abs(posty - heldEvent[numHeldEvents - 1].y) < 4 &&
                    lastFlags & (KD_BUTTON_1 | KD_BUTTON_8)) {
                    DebugF("discarding insignificant movement -- (%d, %d) to "
                           "(%d, %d) from %x\n", postx, posty,
                           heldEvent[numHeldEvents - 1].x,
                           heldEvent[numHeldEvents - 1].y,
                           lastFlags);
                    discard = 1;
                }
                else if (flags & KD_BUTTON_8) {
                    if (lastFlags & KD_BUTTON_8) {
                        DebugF("replaying subsequent thumb events from queue\n");
                        for (i = 0; i < numHeldEvents; i++) {
                            if (heldEvent[i].flags & KD_BUTTON_8) {
                                KdEnqueueMouseEvent(mi,
                                                      heldEvent[i].flags,
                                                      heldEvent[i].x,
                                                      heldEvent[i].y);
                                lastx = heldEvent[i].x;
                                lasty = heldEvent[i].y;
                                lastFlags = heldEvent[i].flags;
                            }
                        }
                    }
                    else {
                        DebugF("discarding previously queued thumb events\n");
                        lastFlags = KD_BUTTON_8;
                    }
                }
                else if (flags & KD_BUTTON_1) {
                    if (lastFlags & KD_BUTTON_8) {
                        DebugF("discarding pen down after thumb down\n");
                        discard = 1;

                        for (i = 0; i < numHeldEvents; i++) {
                            if (heldEvent[i].flags & KD_BUTTON_8) {
                                KdEnqueueMouseEvent(mi,
                                                      heldEvent[i].flags,
                                                      heldEvent[i].x,
                                                      heldEvent[i].y);
                                lastx = heldEvent[i].x;
                                lasty = heldEvent[i].y;
                                lastFlags = heldEvent[i].flags;
                            }
                            else {
                                DebugF("discarding pen down after thumb down "
                                       "(queue)\n");
                            }
                        }
                    }
                    else {
                        DebugF("replaying %d pen events from queue\n", numHeldEvents);
                        for (i = 0; i < numHeldEvents; i++) {
                            if (heldEvent[i].flags & KD_BUTTON_1) {
                                DebugF("    (from queue) event at (%u, %u), "
                                       "pressure is %d, sending flags %x\n",
                                       heldEvent[i].x,
                                       heldEvent[i].y,
                                       heldEvent[i].z,
                                       heldEvent[i].flags);
                                KdEnqueueMouseEvent(mi,
                                                      heldEvent[i].flags,
                                                      heldEvent[i].x,
                                                      heldEvent[i].y);
                                lastx = heldEvent[i].x;
                                lasty = heldEvent[i].y;
                                lastFlags = heldEvent[i].flags;
                            }
                            else {
                                DebugF("discarding thumb event in pen stream?\n");
                            }
                        }
                    }
                }

                numHeldEvents = 0;
            }

            if (!discard) {
                DebugF("capturing and queuing event (%lu, %lu, %d)\n", x, y,
                       event.pressure);
                heldEvent[numHeldEvents].x = x;
                heldEvent[numHeldEvents].y = y;
                heldEvent[numHeldEvents].z = event.pressure;
                heldEvent[numHeldEvents].flags = flags;
                numHeldEvents++;
            } else {
                DebugF("discarding current event\n");
            }

            continue;
        }
        else if (holdEvents) {
            if (numHeldEvents) {
                if (lastFlags & KD_BUTTON_1) {
                    DebugF("pen up received while holding events; replaying "
                           "%d last queued events\n", i);
                    for (i = 0; i < numHeldEvents; i++) {
                        if (heldEvent[i].flags & KD_BUTTON_1) {
                            DebugF("    (from queue) event at (%u, %u), "
                                   "pressure is %d, sending flags %x\n",
                                   heldEvent[i].x,
                                   heldEvent[i].y,
                                   heldEvent[i].z,
                                   heldEvent[i].flags);
                            KdEnqueueMouseEvent(mi, heldEvent[i].flags,
                                                  heldEvent[i].x,
                                                  heldEvent[i].y);
                            lastx = heldEvent[i].x;
                            lasty = heldEvent[i].y;
                            lastFlags = heldEvent[i].flags;
                        }
                        else {
                            DebugF("dropping thumb event in pen stream\n");
                        }
                    }
                }
                else if (lastFlags & KD_BUTTON_8) {
                    DebugF("thumb up received while holding events; replaying "
                           "last queued event, discarding %d\n", i);
                    DebugF("    (from queue) event at (%u, %u), pressure is "
                           "%d, sending flags %x\n", heldEvent[i].x,
                           heldEvent[i].y, heldEvent[i].z,
                           heldEvent[i].flags);
                    for (i = 0; i < numHeldEvents; i++) {
                        if (heldEvent[i].flags & KD_BUTTON_8) {
                            KdEnqueueMouseEvent(mi,
                                                  heldEvent[i].flags,
                                                  heldEvent[i].x,
                                                  heldEvent[i].y);
                            lastx = heldEvent[i].x;
                            lasty = heldEvent[i].y;
                            lastFlags = heldEvent[i].flags;
                        }
                        else {
                            DebugF("dropping pen event in thumb stream\n");
                        }
                    }
                }
                else {
                    i = numHeldEvents - 1;
                    DebugF("less than three events total in queue, sending last\n");
                    DebugF("    (from queue) event at (%u, %u), pressure is "
                           "%d, sending flags %x\n", heldEvent[i].x,
                           heldEvent[i].y, heldEvent[i].z,
                           heldEvent[i].flags);
                    KdEnqueueMouseEvent(mi,
                                          heldEvent[i].flags,
                                          heldEvent[i].x,
                                          heldEvent[i].y);
                    lastx = heldEvent[i].x;
                    lasty = heldEvent[i].y;
                    lastFlags = heldEvent[i].flags;
                }
            }
            numHeldEvents = 0;
            x = lastx;
            y = lasty;
        }

        lastFlags = flags & (KD_BUTTON_1 | KD_BUTTON_8);
        DebugF("direct event at (%lu, %lu), pressure is %d, sending flags %lu\n",
               x, y, event.pressure, flags);
        KdEnqueueMouseEvent(mi, flags, x, y);
        lastx = x;
        lasty = y;
    }
}

static char *TsNames[] = {
  NULL,
  "/dev/input/event0",
  "/dev/ts",	
  "/dev/touchscreen/0",
};

#define NUM_TS_NAMES	(sizeof (TsNames) / sizeof (TsNames[0]))

int TsInputType;

static int
TslibEnable (int not_needed_fd, void *closure)
{
  KdMouseInfo	    *mi = closure;
  int		     fd = 0;

  if(!(tsDev = ts_open(mi->name, 0))) {
    fprintf(stderr, "%s() failed to open %s\n", __func__, mi->name );
    return -1; 			/* XXX Not sure what to return here */
  }
  
  if (ts_config(tsDev))
    return -1;
  fd=ts_fd(tsDev);

  holdEvents = 1;
  numHeldEvents = 0;
  lastFlags = 0;

  return fd;
}

static void
TslibDisable (int fd, void *closure)
{
  ts_close(tsDev);
  tsDev = NULL;
}

static int
TslibInit (void)
{
    int		i, j = 0;
    KdMouseInfo	*mi, *next;
    int		fd= 0;
    int		n = 0;

    if (!TsInputType)
	TsInputType = KdAllocInputType ();

    for (mi = kdMouseInfo; mi; mi = next)
    {
	next = mi->next;
	if (mi->inputType)
	    continue;

	/* Check for tslib env var device setting */
	if ((TsNames[0] = getenv("TSLIB_TSDEVICE")) == NULL)
	  j++;
	
	if (!mi->name)
	{
	    for (i = j; i < NUM_TS_NAMES; i++)    
	    {

	      /* XXX Should check for  */

		if(!(tsDev = ts_open(TsNames[i],0))) continue;
	        if (ts_config(tsDev)) continue;
	        fd=ts_fd(tsDev);
		if (fd >= 0) 
		{
		    mi->name = KdSaveString (TsNames[i]);
		    break;
		}
	    }
	} else {
	  if(!(tsDev = ts_open(mi->name,0))) 
	    continue;
	  if (ts_config(tsDev)) continue; 
	  fd=ts_fd(tsDev);
	}

	if (fd > 0 && tsDev != 0) 
	  {
	    mi->driver = (void *) fd;
	    mi->inputType = TsInputType;
	    if (KdRegisterFd (TsInputType, fd, TsRead, (void *) mi))
	      n++;

	    /* Set callbacks for vt switches etc */
	    KdRegisterFdEnableDisable (fd, TslibEnable, TslibDisable);

	  } 
	else 
	  {
	    fprintf(stderr, "%s() failed to open tslib\n", __func__);	    
	    if (fd > 0) close(fd);
	  }


	}

    return n;
}

static void
TslibFini (void)
{
    KdMouseInfo	*mi;

    KdUnregisterFds (TsInputType, TRUE);
    for (mi = kdMouseInfo; mi; mi = mi->next)
    {
	if (mi->inputType == TsInputType)
	{
	    if(mi->driver && tsDev) {
		ts_close(tsDev);
		tsDev = NULL;
	    }
	    mi->driver = NULL;
	    mi->inputType = 0;
	}
    }
}

KdMouseFuncs TsFuncs = {
    TslibInit,
    TslibFini
};
