/*
 * $Id: layerpict.c,v 1.1.1.1 2004/10/28 11:13:32 lleukkun Exp $
 *
 * Copyright  2001 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "layerstr.h"

void
layerComposite (CARD8      op,
		PicturePtr pSrc,
		PicturePtr pMask,
		PicturePtr pDst,
		INT16      xSrc,
		INT16      ySrc,
		INT16      xMask,
		INT16      yMask,
		INT16      xDst,
		INT16      yDst,
		CARD16     width,
		CARD16     height)
{
    LayerPtr		pLayer;
    DrawablePtr		pDstDrawable = pDst->pDrawable;
    ScreenPtr		pScreen = pDstDrawable->pScreen;
    PictureScreenPtr	ps = GetPictureScreen (pScreen);
    LayerKindPtr	pKind;

    if (pDstDrawable->type == DRAWABLE_WINDOW)
    {
	layerWinPriv((WindowPtr) pDstDrawable);
	pKind = layerWinLayer (pLayWin)->pKind;
    }
    else
    {
	/* XXX assume the first layer can handle all pixmaps */
	layerScrPriv (pScreen);
	pKind = &pLayScr->kinds[0];
	if (pLayScr->pLayers)
	    pKind = pLayScr->pLayers->pKind;
    }
    LayerUnwrap (ps, pKind, Composite);
    (*ps->Composite) (op, pSrc, pMask, pDst, xSrc, ySrc,
		      xMask, yMask, xDst, yDst, width, height);
    LayerWrap (ps, pKind, Composite, layerComposite);
}

void
layerGlyphs (CARD8	    op,
	     PicturePtr	    pSrc,
	     PicturePtr	    pDst,
	     PictFormatPtr  maskFormat,
	     INT16	    xSrc,
	     INT16	    ySrc,
	     int	    nlist,
	     GlyphListPtr   list,
	     GlyphPtr	    *glyphs)
{
    LayerPtr		pLayer;
    DrawablePtr		pDstDrawable = pDst->pDrawable;
    ScreenPtr		pScreen = pDstDrawable->pScreen;
    PictureScreenPtr	ps = GetPictureScreen (pScreen);
    LayerKindPtr	pKind;

    if (pDstDrawable->type == DRAWABLE_WINDOW)
    {
	layerWinPriv((WindowPtr) pDstDrawable);
	pKind = layerWinLayer (pLayWin)->pKind;
    }
    else
    {
	/* XXX assume the first layer can handle all pixmaps */
	layerScrPriv (pScreen);
	pKind = &pLayScr->kinds[0];
	if (pLayScr->pLayers)
	    pKind = pLayScr->pLayers->pKind;
    }
    LayerUnwrap (ps, pKind, Glyphs);
    (*ps->Glyphs) (op, pSrc, pDst, maskFormat, xSrc, ySrc,
		   nlist, list, glyphs);
    LayerWrap (ps, pKind, Glyphs, layerGlyphs);
}

void
layerCompositeRects (CARD8	    op,
		     PicturePtr	    pDst,
		     xRenderColor   *color,
		     int	    nRect,
		     xRectangle	    *rects)
{
    LayerPtr		pLayer;
    DrawablePtr		pDstDrawable = pDst->pDrawable;
    ScreenPtr		pScreen = pDstDrawable->pScreen;
    PictureScreenPtr	ps = GetPictureScreen (pScreen);
    LayerKindPtr	pKind;

    if (pDstDrawable->type == DRAWABLE_WINDOW)
    {
	layerWinPriv((WindowPtr) pDstDrawable);
	pKind = layerWinLayer (pLayWin)->pKind;
    }
    else
    {
	/* XXX assume the first layer can handle all pixmaps */
	layerScrPriv (pScreen);
	pKind = &pLayScr->kinds[0];
	if (pLayScr->pLayers)
	    pKind = pLayScr->pLayers->pKind;
    }
    LayerUnwrap (ps, pKind, CompositeRects);
    (*ps->CompositeRects) (op, pDst, color, nRect, rects);
    LayerWrap (ps, pKind, CompositeRects, layerCompositeRects);
}
