/**
   X Colorkey eXtension

   Authors:
   Tapani Paelli <tapani.palli@nokia.com>
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "xck.h"

/**
   wrapped gc operation
   uses colorkey version of blitting if possible
*/
RegionPtr
xckCopyArea (DrawablePtr pSrcDrawable,
	     DrawablePtr pDstDrawable,
	     GCPtr       pGC,
	     int         xIn,
	     int         yIn,
	     int         widthSrc,
	     int         heightSrc,
	     int         xOut,
	     int         yOut)
{
  RegionPtr ret = NULL;
  PixmapPtr srcpix;
  XID src;
  XCK_GC_OP_PROLOGUE (pGC);

  src = pSrcDrawable -> id;
  srcpix = (PixmapPtr) LookupIDByType (src , RT_PIXMAP);

  /* window source */
  if (!srcpix)
  {
    ret = fbDoCopy (pSrcDrawable, pDstDrawable, pGC, xIn, yIn,
		    widthSrc, heightSrc, xOut, yOut, fbCopyNtoN, 0, 0);
    XCK_GC_OP_EPILOGUE (pGC);
    return ret;
  }

  XCK_data p = xckGetPixPriv (srcpix);
  Bool xclip = FALSE;

  /* x-clipping, go through slower function */
  if (xOut < 0 || xOut+widthSrc > pDstDrawable->width)
    xclip = TRUE;

  if (p->type == XCK_UNKNOWN && pGCPriv->colorkey)
  {
      xckScanPixmap (pSrcDrawable, pGCPriv->colorkey);
  }

  if (pGCPriv->colorkey_active == TRUE && pGCPriv->colorkey)
  {
    if (p->type == XCK_NORMAL)
    {
      ret = fbDoCopy (pSrcDrawable, pDstDrawable, pGC, xIn, yIn,
		      widthSrc, heightSrc, xOut, yOut, fbCopyNtoN, 0, 0);
      XCK_GC_OP_EPILOGUE (pGC);
      return ret;
    }

    else if (p->type == XCK_OPTIMIZE)
    {
      if (xclip == FALSE)
	colorkey_blit (pSrcDrawable,pDstDrawable,xOut,yOut);
      else
	colorkey_blit_xclip (pSrcDrawable,pDstDrawable,xOut,yOut);
    }

    else if (p->type == XCK_COMPLEX)
    {
      /* very slow, pixel by pixel plotting */
      ret = fbDoCopy (pSrcDrawable, pDstDrawable,
		      pGC,                                 /* given graphics context   */
		      0, 0,                               /*  source coordinates          */
		      pSrcDrawable -> width, pSrcDrawable -> height,     /*  source size in pixels       */
		      xOut, yOut,                             /*  destination coordinates     */
		      (fbCopyProc) xckCopyNtoN,        /*  pixel copy function (xck)   */
		      0, 0);                          /*  bitplane,closure (not used) */
    }

  } /* if colorkey enabled */

  else
  {
    /* colorkey not active, use normal fb operation */
    ret = fbDoCopy (pSrcDrawable, pDstDrawable, pGC, xIn, yIn,
		    widthSrc, heightSrc, xOut, yOut, fbCopyNtoN, 0, 0);
  }

  XCK_GC_OP_EPILOGUE (pGC);
  return ret;
}
