/**
   X Colorkey eXtension

   Authors:
   Tapani Paelli <tapani.palli@nokia.com>
*/

#ifndef _XCK_H_
#define _XCK_H_

/**
   scrnintstr.h includes 'screenInfo' structure,
   which contains a pointer to every screen.
   gcstruct.h contains definitions of GCOps
   and GCFuncs function pointers.
*/

#include <X11/X.h>
#include <X11/Xproto.h>

#include "scrnintstr.h"
#include "gcstruct.h"

#include "misc.h"
#include "os.h"
#include "dixstruct.h"
#include "extnsionst.h"
#include "pixmapstr.h"
#include "servermd.h"    /* PIXMAPBYTEPAD */

#include "fb.h"




/**
   different types for a colorkeyed pixmap
*/
#define XCK_UNKNOWN  0      // not scanned yet
#define XCK_NORMAL   1      // no transparency
#define XCK_COMPLEX  2      // check every pixel
#define XCK_OPTIMIZE 3      // optimized

/* this struct is stored in pixmap devprivates */
typedef struct
{
  unsigned short type;

  /* includes memcpy position and bytecount */
  unsigned int *position_map;

  /* offsets for blitting (how much can be skipped max) */
  /* left and right offsets can be used in COMPLEX mode */
  unsigned int l_offset;
  unsigned int r_offset;
  unsigned int u_offset;
  unsigned int d_offset;

} XCK_data_rec, *XCK_data;

/* private indexes for storing data */
int xckScrPrivateIndex;
int xckPixPrivateIndex;
int xckGCPrivateIndex;

extern const GCOps xckGCOps;

/**
   wrapped screen functions
*/
typedef struct _xckScrPriv {
  CreatePixmapProcPtr         CreatePixmap;
  DestroyPixmapProcPtr        DestroyPixmap;
  CreateGCProcPtr             CreateGC;
} xckScrPrivRec, *xckScrPrivPtr;

/**
   structure to GC devprivates
*/
typedef struct _xckGCPriv {
  Bool colorkey_active;
  long colorkey;

  GCOps   *ops;
  GCFuncs *funcs;
} xckGCPrivRec, *xckGCPrivPtr;

/**
   these macros are from damage extension
   Copyright © 2003 Keith Packard
*/
#define wrap(priv, real, mem, func) {\
    priv->mem = real->mem; \
    real->mem = func; \
}
#define unwrap(priv, real, mem) {\
    real->mem = priv->mem; \
}


/**
   these macros help when using devprivates
   Copyright © 2003 Keith Packard
*/
#define xckGetScrPriv(pScr) \
((xckScrPrivPtr) (pScr)->devPrivates[xckScrPrivateIndex].ptr)

#define xckScrPriv(pScr) \
xckScrPrivPtr    pScrPriv = xckGetScrPriv(pScr)

#define xckGetPixPriv(pPix) \
((XCK_data) (pPix)->devPrivates[xckPixPrivateIndex].ptr)

#define xckGetGCPriv(pGC) \
(xckGCPrivPtr)((pGC)->devPrivates[xckGCPrivateIndex].ptr)


#define XCK_GC_OP_PROLOGUE(pGC)\
    xckScrPrivPtr pPriv = xckGetScrPriv(pGC->pScreen); \
    xckGCPrivPtr pGCPriv = xckGetGCPriv(pGC);\
    GCFuncs *oldFuncs = pGC->funcs;\
    pGC->funcs = pGCPriv->funcs;\
    pGC->ops = pGCPriv->ops

#define XCK_GC_OP_EPILOGUE(pGC)\
    pGCPriv->ops = pGC->ops;\
    pGC->funcs = oldFuncs;\
    pGC->ops   = &xckGCOps

/* function declarations */

static Bool
xckCreateGC (GCPtr pGC)
{
  ScreenPtr pScreen = pGC->pScreen;
  xckScrPrivPtr pPriv = xckGetScrPriv(pScreen);
  xckGCPrivPtr pGCPriv = xckGetGCPriv(pGC);
  Bool ret;

  pScreen->CreateGC = pPriv->CreateGC;

  if((ret = (*pScreen->CreateGC) (pGC)))
  {
    pGCPriv->ops = NULL;
    pGCPriv->funcs = pGC->funcs;
    pGCPriv->colorkey_active = FALSE;
    pGCPriv->colorkey = -1;
  }

  pScreen->CreateGC = xckCreateGC;
  pGC->ops = (GCOps *) &xckGCOps;
  return ret;
}


/**********************************************************************
**********************************************************************/

PixmapPtr
xckCreatePixmap(ScreenPtr pScreen, int width, int height,int depth);

Bool
xckDestroyPixmap (PixmapPtr pPixmap);

void
xckScanPixmap (DrawablePtr pDrawable, int ckey);

void
colorkey_blit (DrawablePtr pSrc, DrawablePtr pDst, int dstXoff, int dstYoff);

void
colorkey_blit_xclip (DrawablePtr pSrc, DrawablePtr pDst, int dstXoff, int dstYoff);

void
InitColorkeyExtension (void);

BOOL
init_screen (ScreenPtr pScreen);

RegionPtr
xckCopyArea (DrawablePtr pSrcDrawable,
	     DrawablePtr pDstDrawable,
	     GCPtr       pGC,
	     int         xIn,
	     int         yIn,
	     int         widthSrc,
	     int         heightSrc,
	     int         xOut,
	     int         yOut);


void
xckPolyFillRect(DrawablePtr  pDrawable,
		GCPtr        pGC,
		int          nrect,
		xRectangle   *prect);

void
xckBlt (FbBits   *srcLine,
        int      srcStride,
        int      srcX,
        FbBits   *dstLine,
        int      dstStride,
        int      dstX,
        int      width,
        int      height,
        int      alu,
        FbBits   pm,
        int      bpp,
        Bool     reverse,
        Bool     upsidedown,
        int      ckey);


void
xckCopyNtoN (DrawablePtr pSrcDrawable,
	     DrawablePtr pDstDrawable,
	     GCPtr       pGC,
	     BoxPtr      pbox,
	     int         nbox,
	     int         dx,
	     int         dy,
	     Bool        reverse,
	     Bool        upsidedown,
	     Pixel       bitplane,
	     void        *closure);


void
xckEvenTile (FbBits     *dst,
             int        dstStride,
             int        dstX,
                                                                                                                                                        
             int        width,
             int        height,
                                                                                                                                                        
             FbBits     *tile,
	     int        tileStride,
	     int        tileWidth,
             int        tileHeight,
                                                                                                                                                        
             int        alu,
             FbBits     pm,
             int        xRot,
             int        yRot,
             int        ckey,
	     XCK_data pdata
	     );


void
xckOddTile(FbBits    *dst,
           int      dstStride,
           int      dstX,
                                                                                                                                                        
           int      width,
           int      height,
                                                                                                                                                        
           FbBits    *tile,
           int      tileStride,
           int      tileWidth,
           int      tileHeight,
                                                                                                                                                        
           int      alu,
           FbBits    pm,
           int      bpp,
                                                                                                                                                        
           int      xRot,
           int      yRot,
           int      ckey,
	   XCK_data pdata
	   );

void
xckTile (FbBits     *dst,
         int        dstStride,
         int        dstX,
         int        width,
         int        height,
         FbBits     *tile,
         int        tileStride,
         int        tileWidth,
         int        tileHeight,
         int        alu,
         FbBits     pm,
         int        bpp,
         int        xRot,
         int        yRot,
         int        ckey,
         XCK_data pdata
         );

void
xckFill (DrawablePtr pDrawable,
	 GCPtr       pGC,
	 int         x,
	 int         y,
	 int         width,
	 int         height);

void
xckSolidBoxClipped (DrawablePtr pDrawable,
		    RegionPtr    pClip,
		    int          x1,
		    int          y1,
		    int          x2,
		    int          y2,
		    FbBits       and,
		    FbBits       xor);
#endif
