/*
 * Copyright (c) 2003 Nokia
 * Author: tsavola@movial.fi
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include "types.h"

/** Default port number. */
#define DEFAULT_PORT  1202

/** Maximum username length including the nul-terminator. */
#define USER_SIZE       16

/** Maximum password length including the nul-terminator. */
#define PWD_SIZE        16

/** Maximum hostname length including the nul-terminator. */
#define HOST_SIZE      256

#define MTYPE_NFS_S    "nfs"
#define MTYPE_BIND_S   "bind"

typedef void (free_func_t)(void *);

extern int set_nonblocking(int fd, bool_t nonblock);
extern int set_closeonexec(int fd);
extern int setsockopt_bool(int s, int level, int optname, bool_t value);
extern char *get_progname(char *name);
extern uint32_t resolve(const char *);
extern void free_vec(void **vec, free_func_t *);
extern size_t calc_vec_len(void **vec);
extern ssize_t read_line(FILE *file, char *buf, size_t size);
extern char *skip_spaces(char *str);
extern char *find_space(char *str);
extern char *find_line(char *str);
extern char *trim_string(char *str);
extern int split_string(char *line, ...);
extern size_t string_cat(char *buf, size_t bufsize, const char *piece, ...);

/** "Out of memory" */
extern const char *oom;

/* This is defined in client.c and daemon.c */
void error(const char *msg, ...);

#define error_noerr  errno = 0; error

#endif
