/* This is exapmle of a test library for OUTO. 

   This file is under no copyright what so ever (e.g. is public domain)
   as this is ment for copypaste

   You may use contents of this file as You see fit.

   read also the README file please
 */


#include <assert.h>
#include <stdio.h>
/* #include "yoursoftware.h" */

/* this is required */
#include <outo.h>

/* 
 * The tests functions may be named how ever, but they must take no parameters
 * and return int.
 *
 * All debug info goes to the debug file, which is defined on command line or
 * /tmp/.outo by default
 *
 * Each test is run separately so that _only_ init_tests() is run. You may not
 * assume that earlier tests are done when a test is run.
 *
 * @return 1 on succes, 0 (or anything else) on failure. 
 * The return code can be found on the debug (not yet :)
 */

/*--------------BASIC CASES__________________*/

int test1()
{
  printf("test one output\n");
  return 1; /* succes */
}

int test2()
{
  fprintf(stderr, "test two output to stderr\n");
  return 0; /* failure */
}


/*------------- ASSERT CASES ------------------*/

/** 
 * this test will throw assert, which the tester will detect and consider the
 * test failed 
 */
int test3()
{
  int something_wrong=0;
  assert(something_wrong);
  return 1;
}

/** this test is wanted to throw assert, which is will do and thus be passed */
int test4()
{
  printf("now should throw an assert\n");
  assert(0);
  return 1;
}


/*---------------INITIALIZATION---------------*/

/** This function is called just before every test, if exists
 * If init_test() does not excist, it just is not called 
 */
void init_test()
{
  /* init your tests here */
}


/*------------------ GENERAL ------------------*/

/** 
 * The tests cases, i.e. a pointer to the test function, explanation and
 * what is the expected result, normal return or assert
 *
 * struct testcase is defined in outo.h
 */
testcase cases[] = {
  {*test1, "test one description here", EXPECT_OK},
  {*test2, "test two, will fail", EXPECT_OK},
  {*test3, "test three description which is too long and will be cutted", 
           EXPECT_OK},
  {*test4, "test four blah blah", EXPECT_ASSERT},
  {0} /* remember the terminating null */
};


/** 
 * The get_tests function
 *
 * You should not change this function to do anythin else than return the 
 * struct array, because things which use any form of IPC may break (e.g.
 * shared memory, pipes, sockets). Do initing your tests in init_tests()
 *
 *  @return a null terminating array of testcase structs
 */
testcase* get_tests()
{ 
  return cases;
}

