/*
 * This file is part of maemo-dm
 *
 * Copyright (C) 2006 Nokia Corporation.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 * On Debian GNU/Linux systems, the complete text of the GNU General
 * Public License can be found in `/usr/share/common-licenses/LGPL'.
 */

#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
const static gchar unload_storage[]  = "/sbin/rmmod g_file_storage";
const static gchar activate_usbnet[] = "/sbin/ifup usb0";
const static gchar load_geth[]       = "/sbin/insmod "
"/mnt/initfs/lib/modules/current/g_ether.ko";
const static gchar get_rndmode[]     = "/usr/sbin/chroot /mnt/initfs "
"cal-tool --get-rd-mode";
const static gchar activate_sbrshd_cmd[]   = "/etc/init.d/sbrshd start";
const static gchar deactivate_sbrshd_cmd[] = "/etc/init.d/sbrshd stop";
const static gchar activate_nfs_cmd1[]     = "/sbin/modprobe nfs";
const static gchar activate_nfs_cmd2[]     = "/etc/init.d/portmap start";
const static gchar deactivate_nfs_cmd1[]   = "/etc/init.d/portmap stop";
const static gchar deactivate_nfs_cmd2[]   = "/sbin/rmmod nfs lockd sunrpc";

static void activate_nfs(void) {
  g_spawn_command_line_sync(activate_nfs_cmd1,
			    NULL,NULL,NULL,NULL);
  g_spawn_command_line_sync(activate_nfs_cmd2,
			    NULL,NULL,NULL,NULL);
  
}

static void deactivate_nfs(void) {
  g_spawn_command_line_sync(deactivate_nfs_cmd1,
			    NULL,NULL,NULL,NULL);
  g_spawn_command_line_sync(deactivate_nfs_cmd2,
			    NULL,NULL,NULL,NULL);
  
}

static void activate_sbrshd(void) {
  g_spawn_command_line_sync(activate_sbrshd_cmd,
			    NULL,NULL,NULL,NULL);
  
}

static void deactivate_sbrshd(void) {
  g_spawn_command_line_sync(deactivate_sbrshd_cmd,
			    NULL,NULL,NULL,NULL);
  
}

static int activate_usbnet_action(void) {
  int status;
  
  g_spawn_command_line_sync(unload_storage,
			    NULL,NULL,NULL,NULL);
  
  g_spawn_command_line_sync(load_geth,
			    NULL,NULL,NULL,NULL);
  if (g_spawn_command_line_sync(activate_usbnet,NULL,NULL,&status,NULL)) {
    if (status == 0) {
      return 0;
    }
  }
  return 1;
}

int main (int argc, char *argv[])
{
  if (argc==2) {
    if (strcmp(argv[1],"as")==0) {
      activate_sbrshd();
      return 0;
    } if (strcmp(argv[1],"ss")==0) {
      deactivate_sbrshd();
      return 0;
    } else if (strcmp(argv[1],"an")==0) {
      activate_nfs();
      return 0;
    } else if (strcmp(argv[1],"sn")==0) {
      deactivate_nfs();
      return 0;
    } else {
      gchar* rndmode=NULL;
      
      g_spawn_command_line_sync(get_rndmode,
				&rndmode,NULL,NULL,NULL);
      if (g_ascii_strncasecmp(rndmode,"enabled",7)==0) {
	return activate_usbnet_action();
      }
      return 2;
    }
  }
  return activate_usbnet_action();
}
