/*
 * This file is part of maemo-dm
 *
 * Copyright (C) 2006 Nokia Corporation.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 * On Debian GNU/Linux systems, the complete text of the GNU General
 * Public License can be found in `/usr/share/common-licenses/LGPL'.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <hildon-status-bar-lib/hildon-status-bar-item.h>
#include "libmaemodm.h"

#define HILDON_STATUS_BAR_PRIORITY  1

#define SERVICE "com.nokia.maemo-dm-statusbar"
#define OBJECT_PATH "/com/nokia/maemo-dm-statusbar"
#define INTERFACE SERVICE"/maemo-dm"

typedef struct
{
  HildonStatusBarItem  *item;
  GtkWidget            *button;
} PluginInfo;

/* The exported function.
 */
void maemodm_sb_entry (HildonStatusBarPluginFn_st *fn);

static void *
initialize (HildonStatusBarItem *item, GtkWidget **button)
{
  PluginInfo *info = NULL;
  
  g_return_val_if_fail (item, NULL);

  info = g_new0 (PluginInfo, 1);

  info->item = item;
  info->button = maemo_dm_button_new ();
  g_signal_connect (G_OBJECT (info->button), "clicked",
		    G_CALLBACK (maemo_dm_dialog_show),
		    NULL);
		    
  *button = info->button;
  
  return info;
}

static void
destroy (void *data)
{
  PluginInfo *info =  (PluginInfo*)data;
  g_return_if_fail (info);
  g_free (info);
}

static gint
get_priority (void *data)
{
  return HILDON_STATUS_BAR_PRIORITY;
}

void
update  (void *data, gint value1, gint value2, const gchar *str)
{
  PluginInfo *info = (PluginInfo*)data;
  g_return_if_fail (info);
  
  if (value2 == 0)
    gtk_widget_destroy (GTK_WIDGET(info->item));
  else {
    gtk_widget_show_all (info->button);
  }
  return;
}

void
maemodm_sb_entry (HildonStatusBarPluginFn_st *fn)
{
  g_spawn_command_line_sync("sudo /usr/bin/maemo-dm 1",NULL,NULL,NULL,NULL);
  g_return_if_fail (fn);
  fn->initialize   = initialize;
  fn->destroy      = destroy;
  fn->update       = update;
  fn->get_priority = get_priority;
}
