%define version 0.3.0
%define release 3

%define pbuildroot %{_tmppath}/libjingle-%{version}-root

Name: libjingle
Summary: libjingle is a set of libraries to interoperate with GoogleTalk
Version: %{version}
Release: %{release}
License: BSD
Packager: Jussi Laako <jussi.laako@nokia.com>
Group: System/Libraries
Source: libjingle-%{version}.tar.gz
Source10: jingle-relay
Source11: jingle-stun
Patch: libjingle.patch
BuildRoot: %{pbuildroot}
Requires: expat, openssl, ortp
BuildRequires: expat, openssl-devel, ortp-devel

%description
Libjingle is a set of components provided by Google to interoperate with Google
Talk's peer-to-peer and voice capabilities.

%package devel
Summary: Files needed to develop programs using libjingle library
Group: Development/Libraries

%description devel
This package contains the addtitional header files, documentation and
libraries you need to develop programs using the libjingle library.

%prep
%setup -q -n libjingle-%{version}
%patch -p1

%build
autoreconf --force --install
export CFLAGS="$RPM_OPT_FLAGS -ffast-math"
export CXXFLAGS="$RPM_OPT_FLAGS -ffast-math"
./configure --prefix=%{_prefix} --bindir=%{_bindir} \
	--libexecdir=%{_libexecdir} --datadir=%{_datadir} \
	--sysconfdir=%{_sysconfdir} --sharedstatedir=%{_sharedstatedir} \
	--localstatedir=%{_localstatedir} --libdir=%{_libdir} \
	--includedir=%{_includedir} --infodir=%{_infodir} --mandir=%{_mandir}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
install -m 755 -d $RPM_BUILD_ROOT/etc/init.d
install -m 755 %{SOURCE10} $RPM_BUILD_ROOT/etc/init.d/
install -m 755 %{SOURCE11} $RPM_BUILD_ROOT/etc/init.d/

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README
#%{_bindir}/call
#%{_bindir}/login
%{_bindir}/relayserver
%{_bindir}/stunserver
#%{_bindir}/pcp
%{_libdir}/libjingle*.so.*
%{_sysconfdir}/init.d/jingle-*

%files devel
%defattr(-,root,root,-)
%{_includedir}/libjingle/*
%{_libdir}/libjingle*.*a
%{_libdir}/pkgconfig/jingle*

%changelog
* Wed Mar 29 2006 Jussi Laako <jussi.laako@nokia.com>
- Update to a new version
* Mon Mar 13 2006 Jussi Laako <jussi.laako@nokia.com>
- Update to a new version
* Thu Dec 29 2005 Jussi Laako <jussi.laako@nokia.com>
- First RPM package
