" Vim syntax file
" Language:     C galago
" Maintainer:   Christian Hammond
" Last change:  2005-05-01

" galago-account.h
syn keyword galagoType		GalagoAccount
syn keyword galagoType		GalagoAccountClass
syn keyword galagoType		GalagoAccountPrivate
syn keyword galagoConstant	GALAGO_CLASS_ACCOUNT
syn keyword galagoConstant	GALAGO_DBUS_ACCOUNT_INTERFACE
syn keyword galagoMacro		GALAGO_IS_ACCOUNT
syn keyword galagoFunction	galago_account_get_class
syn keyword galagoFunction	galago_account_new
syn keyword galagoFunction	galago_account_set_connected
syn keyword galagoFunction	galago_account_get_service
syn keyword galagoFunction	galago_account_set_person
syn keyword galagoFunction	galago_account_get_person
syn keyword galagoFunction	galago_account_get_username
syn keyword galagoFunction	galago_account_is_connected
syn keyword galagoFunction	galago_account_is_native
syn keyword galagoFunction	galago_account_set_display_name
syn keyword galagoFunction	galago_account_get_display_name
syn keyword galagoFunction	galago_account_is_display_name_set
syn keyword galagoFunction	galago_account_add_contact
syn keyword galagoFunction	galago_account_remove_contact
syn keyword galagoFunction	galago_account_get_contact
syn keyword galagoFunction	galago_account_get_contacts
syn keyword galagoFunction	galago_account_set_presence
syn keyword galagoFunction	galago_account_get_presence
syn keyword galagoFunction	galago_account_set_avatar
syn keyword galagoFunction	galago_account_get_avatar

" galago-assert.h
syn keyword galagoMacro		galago_return_if_fail
syn keyword galagoMacro		galago_return_val_if_fail
syn keyword galagoMacro		galago_goto_if_fail

" galago-avatar.h
syn keyword galagoType		GalagoAvatar
syn keyword galagoType		GalagoAvatarClass
syn keyword galagoType		GalagoAvatarPrivate
syn keyword galagoConstant	GALAGO_CLASS_AVATAR
syn keyword galagoConstant	GALAGO_DBUS_AVATAR_INTERFACE
syn keyword galagoMacro     GALAGO_IS_AVATAR
syn keyword galagoFunction	galago_avatar_get_class
syn keyword galagoFunction	galago_avatar_new
syn keyword galagoFunction	galago_avatar_set_image_data
syn keyword galagoFunction	galago_avatar_get_account
syn keyword galagoFunction	galago_avatar_get_image_data

" galago-context-base.h
syn keyword galagoType		GalagoContext
syn keyword galagoType		GalagoContextPrivate

" galago-context-priv.h
syn keyword galagoType		GalagoContextOps
syn keyword galagoFunction	galago_context_add_service
syn keyword galagoFunction	galago_context_remove_service
syn keyword galagoFunction	galago_context_add_person
syn keyword galagoFunction	galago_context_remove_person
syn keyword galagoFunction	galago_context_add_object
syn keyword galagoFunction	galago_context_remove_object
syn keyword galagoFunction	galago_context_clear_objects

" galago-context.h
syn keyword galagoFunction	galago_context_new
syn keyword galagoFunction	galago_context_destroy
syn keyword galagoFunction	galago_context_push
syn keyword galagoFunction	galago_context_pop
syn keyword galagoFunction	galago_context_get
syn keyword galagoFunction	galago_context_set_obj_path_prefix
syn keyword galagoFunction	galago_context_get_obj_path_prefix
syn keyword galagoFunction	galago_context_get_service
syn keyword galagoFunction	galago_context_get_services
syn keyword galagoFunction	galago_context_get_person
syn keyword galagoFunction	galago_context_get_people
syn keyword galagoFunction	galago_context_get_object

" galago-core.h
syn keyword galagoType		GalagoCore
syn keyword galagoConstant	GALAGO_DBUS_CORE_INTERFACE
syn keyword galagoConstant	GALAGO_DBUS_CORE_OBJECT
syn keyword galagoFunction	galago_init
syn keyword galagoFunction	galago_init_with_mainloop
syn keyword galagoFunction	galago_uninit
syn keyword galagoFunction	galago_is_initted
syn keyword galagoFunction	galago_is_connected
syn keyword galagoFunction	galago_is_registered
syn keyword galagoFunction	galago_is_daemon_active
syn keyword galagoFunction	galago_is_daemon
syn keyword galagoFunction	galago_core_get_dbus_conn
syn keyword galagoFunction	galago_core_get_uid
syn keyword galagoFunction	galago_core_get_obj_path
syn keyword galagoFunction	galago_core_is_feed
syn keyword galagoFunction	galago_core_set_watch_all
syn keyword galagoFunction	galago_core_get_watch_all
syn keyword galagoFunction	galago_core_set_exit_with_daemon
syn keyword galagoFunction	galago_core_get_exit_with_daemon
syn keyword galagoFunction	galago_core_add_service
syn keyword galagoFunction	galago_core_remove_service
syn keyword galagoFunction	galago_core_get_service
syn keyword galagoFunction	galago_core_get_services
syn keyword galagoFunction	galago_core_add_person
syn keyword galagoFunction	galago_core_remove_person
syn keyword galagoFunction	galago_core_get_person
syn keyword galagoFunction	galago_core_get_people
syn keyword galagoFunction	galago_core_get_me
syn keyword galagoFunction	galago_get_core
syn keyword galagoMacro		galago_glib_init

" galago-dbus.h
syn keyword galagoConstant	GALAGO_DBUS_SERVICE
syn keyword galagoFunction	galago_dbus_message_iter_append_string_or_nil
syn keyword galagoFunction	galago_dbus_message_iter_get_string_or_nil
syn keyword galagoFunction	galago_dbus_message_iter_append_object
syn keyword galagoFunction	galago_dbus_message_iter_append_object_list
syn keyword galagoFunction	galago_dbus_message_iter_get_object
syn keyword galagoFunction	galago_dbus_message_iter_get_object_list
syn keyword galagoFunction	galago_dbus_message_new_method_call
syn keyword galagoFunction	galago_dbus_message_new_method_call_vargs
syn keyword galagoFunction	galago_dbus_message_new_method_call_args
syn keyword galagoFunction	galago_dbus_send_message
syn keyword galagoFunction	galago_dbus_send_message_with_reply
syn keyword galagoFunction	galago_dbus_object_push_full

" galago-hashtable.h
syn keyword galagoType		GalagoHashTable
syn keyword galagoFunction	galago_hash_table_new
syn keyword galagoFunction	galago_hash_table_new_full
syn keyword galagoFunction	galago_hash_table_destroy
syn keyword galagoFunction	galago_hash_table_clear
syn keyword galagoFunction	galago_hash_table_insert
syn keyword galagoFunction	galago_hash_table_replace
syn keyword galagoFunction	galago_hash_table_remove
syn keyword galagoFunction	galago_hash_table_lookup
syn keyword galagoFunction	galago_hash_table_exists
syn keyword galagoFunction	galago_hash_table_get_keys
syn keyword galagoFunction	galago_hash_table_get_values
syn keyword galagoFunction	galago_hash_table_foreach
syn keyword galagoFunction	galago_hash_table_foreach_key
syn keyword galagoFunction	galago_hash_table_foreach_value
syn keyword galagoFunction	galago_hash_table_get_size
syn keyword galagoFunction	galago_str_equal
syn keyword galagoFunction	galago_str_hash
syn keyword galagoFunction	galago_int_equal
syn keyword galagoFunction	galago_int_hash
syn keyword galagoFunction	galago_direct_equal
syn keyword galagoFunction	galago_direct_hash

" galago-image.h
syn keyword galagoType		GalagoImage
syn keyword galagoType		GalagoImageClass
syn keyword galagoType		GalagoImagePrivate
syn keyword galagoConstant	GALAGO_CLASS_IMAGE
syn keyword galagoConstant	GALAGO_IMAGE
syn keyword galagoMacro		GALAGO_IS_IMAGE
syn keyword galagoFunction	galago_image_get_class
syn keyword galagoFunction	galago_image_set_image_data
syn keyword galagoFunction	galago_image_get_image_data

" galago-list.h
syn keyword galagoType		GalagoList
syn keyword galagoFunction	galago_list_new
syn keyword galagoFunction	galago_list_destroy
syn keyword galagoFunction	galago_list_destroy_1
syn keyword galagoFunction	galago_list_dup
syn keyword galagoFunction	galago_list_append
syn keyword galagoFunction	galago_list_prepend
syn keyword galagoFunction	galago_list_remove
syn keyword galagoFunction	galago_list_remove_link
syn keyword galagoFunction	galago_list_delete_link
syn keyword galagoFunction	galago_list_find
syn keyword galagoFunction	galago_list_foreach
syn keyword galagoFunction	galago_list_get_first
syn keyword galagoFunction	galago_list_get_last
syn keyword galagoFunction	galago_list_get_count

" galago-log.h
syn keyword galagoType		GalagoLogLevel
syn keyword galagoType		GalagoLogHandlerFunc
syn keyword galagoConstant	GALAGO_LOG_ALL
syn keyword galagoConstant	GALAGO_LOG_MISC
syn keyword galagoConstant	GALAGO_LOG_INFO
syn keyword galagoConstant	GALAGO_LOG_WARNING
syn keyword galagoConstant	GALAGO_LOG_ERROR
syn keyword galagoConstant	GALAGO_LOG_FATAL
syn keyword galagoConstant	GALAGO_LOG_ASSERT
syn keyword galagoConstant	GALAGO_LOG_NUM_LEVELS
syn keyword galagoFunction	galago_log_set_enabled
syn keyword galagoFunction	galago_log_set_handler
syn keyword galagoFunction	galago_log_unset_handler
syn keyword galagoFunction	galago_log
syn keyword galagoFunction	galago_log_misc
syn keyword galagoFunction	galago_log_info
syn keyword galagoFunction	galago_log_warning
syn keyword galagoFunction	galago_log_error
syn keyword galagoFunction	galago_log_fatal
syn keyword galagoFunction	galago_log_args

" galago-marshal.h
syn keyword galagoFunction	galago_marshal_VOID
syn keyword galagoFunction	galago_marshal_VOID__POINTER
syn keyword galagoFunction	galago_marshal_VOID__BOXED
syn keyword galagoFunction	galago_marshal_VOID__BOOLEAN_ULONG
syn keyword galagoFunction	galago_marshal_VOID__POINTER_STRING

" galago-object.h
syn keyword galagoType		GalagoObject
syn keyword galagoType		GalagoObjectPrivate
syn keyword galagoType		GalagoObjectClass
syn keyword galagoType		GalagoObjectClassInfo
syn keyword galagoType		GalagoObjectClassPrivate
syn keyword galagoType		GalagoObjectClassInitFunc
syn keyword galagoType		GalagoObjectClassFinalizeFunc
syn keyword galagoType		GalagoObjectInitFunc
syn keyword galagoType		GalagoObjectFlags
syn keyword galagoType		GalagoObjectClassFlags
syn keyword galagoConstant	GALAGO_FLAG_FINALIZING
syn keyword galagoConstant	GALAGO_FLAG_ABSTRACT
syn keyword galagoConstant	GALAGO_OBJECT_MAGIC
syn keyword galagoConstant	GALAGO_CLASS_MAGIC
syn keyword galagoMacro		GALAGO_IS_OBJECT
syn keyword galagoMacro		GALAGO_IS_CLASS
syn keyword galagoMacro		GALAGO_OBJECT
syn keyword galagoMacro		GALAGO_OBJECT_CLASS
syn keyword galagoMacro		GALAGO_OBJECT_CAST
syn keyword galagoMacro		GALAGO_OBJECT_GET_FLAGS
syn keyword galagoMacro		GALAGO_OBJECT_SET_FLAGS
syn keyword galagoMacro		GALAGO_OBJECT_SET_FLAG
syn keyword galagoMacro		GALAGO_OBJECT_UNSET_FLAG
syn keyword galagoMacro		GALAGO_OBJECT_HAS_FLAG
syn keyword galagoFunction	galago_class_register
syn keyword galagoFunction	galago_class_get_parent
syn keyword galagoFunction	galago_class_get_name
syn keyword galagoFunction	galago_class_get_dbus_iface
syn keyword galagoFunction	galago_class_get_signal_context
syn keyword galagoFunction	galago_object_new
syn keyword galagoFunction	galago_object_ref
syn keyword galagoFunction	galago_object_unref
syn keyword galagoFunction	galago_object_get_class
syn keyword galagoFunction	galago_object_set_flags
syn keyword galagoFunction	galago_object_get_flags
syn keyword galagoFunction	galago_object_set_dbus_path
syn keyword galagoFunction	galago_object_get_dbus_path
syn keyword galagoFunction	galago_object_set_watch
syn keyword galagoFunction	galago_object_is_watched
syn keyword galagoFunction	galago_object_set_data
syn keyword galagoFunction	galago_object_get_data
syn keyword galagoFunction	galago_object_get_context
syn keyword galagoFunction	galago_object_check_cast

" galago-object-utils.h
syn keyword galagoMacro		GALAGO_REGISTER_CLASS

" galago-person.h
syn keyword galagoType		GalagoPerson
syn keyword galagoType		GalagoPersonClass
syn keyword galagoType		GalagoPersonPrivate
syn keyword galagoType		GalagoPropertyType
syn keyword galagoConstant	GALAGO_PROPERTY_TYPE_UNKNOWN
syn keyword galagoConstant	GALAGO_PROPERTY_TYPE_STRING
syn keyword galagoConstant	GALAGO_PROPERTY_TYPE_BOOL
syn keyword galagoConstant	GALAGO_PROPERTY_TYPE_UINT32
syn keyword galagoConstant	GALAGO_CLASS_PERSON
syn keyword galagoConstant	GALAGO_DBUS_PERSON_INTERFACE
syn keyword galagoConstant	GALAGO_PERSON_PROP_FIRST_NAME
syn keyword galagoConstant	GALAGO_PERSON_PROP_MIDDLE_NAME
syn keyword galagoConstant	GALAGO_PERSON_PROP_LAST_NAME
syn keyword galagoConstant	GALAGO_PERSON_PROP_ADDRESS
syn keyword galagoConstant	GALAGO_PERSON_PROP_CITY
syn keyword galagoConstant	GALAGO_PERSON_PROP_STATE
syn keyword galagoConstant	GALAGO_PERSON_PROP_COUNTRY
syn keyword galagoConstant	GALAGO_PERSON_PROP_ZIPCODE
syn keyword galagoMacro		GALAGO_IS_PERSON
syn keyword galagoFunction	galago_person_get_class
syn keyword galagoFunction	galago_person_new
syn keyword galagoFunction	galago_person_me_new
syn keyword galagoFunction	galago_person_set_me
syn keyword galagoFunction	galago_person_is_me
syn keyword galagoFunction	galago_person_get_id
syn keyword galagoFunction	galago_person_is_native
syn keyword galagoFunction	galago_person_get_display_name
syn keyword galagoFunction	galago_person_set_photo
syn keyword galagoFunction	galago_person_get_photo
syn keyword galagoFunction	galago_person_has_accounts
syn keyword galagoFunction	galago_person_get_accounts
syn keyword galagoFunction	galago_person_get_priority_account
syn keyword galagoFunction	galago_person_add_account
syn keyword galagoFunction	galago_person_remove_account
syn keyword galagoFunction	galago_person_get_account
syn keyword galagoFunction	galago_person_set_property_string
syn keyword galagoFunction	galago_person_set_property_bool
syn keyword galagoFunction	galago_person_set_property_uint32
syn keyword galagoFunction	galago_person_set_property
syn keyword galagoFunction	galago_person_remove_property
syn keyword galagoFunction	galago_person_get_property_string
syn keyword galagoFunction	galago_person_get_property_bool
syn keyword galagoFunction	galago_person_get_property_uint32
syn keyword galagoFunction	galago_person_get_property

" galago-photo.h
syn keyword galagoType		GalagoPhoto
syn keyword galagoType		GalagoPhotoClass
syn keyword galagoType		GalagoPhotoPrivate
syn keyword galagoConstant	GALAGO_CLASS_PHOTO
syn keyword galagoConstant	GALAGO_DBUS_PHOTO_INTERFACE
syn keyword galagoMacro		GALAGO_IS_PHOTO
syn keyword galagoFunction	galago_photo_get_class
syn keyword galagoFunction	galago_photo_new
syn keyword galagoFunction	galago_photo_set_image_data
syn keyword galagoFunction	galago_photo_get_person
syn keyword galagoFunction	galago_photo_get_image_data

" galago-presence.h
syn keyword galagoType		GalagoPresence
syn keyword galagoType		GalagoPresenceClass
syn keyword galagoType		GalagoPresencePrivate
syn keyword galagoConstant	GALAGO_CLASS_PRESENCE
syn keyword galagoConstant	GALAGO_DBUS_PRESENCE_INTERFACE
syn keyword galagoMacro		GALAGO_IS_PRESENCE
syn keyword galagoFunction	galago_presence_get_class
syn keyword galagoFunction	galago_presence_new
syn keyword galagoFunction	galago_presence_set_idle
syn keyword galagoFunction	galago_presence_set_statuses
syn keyword galagoFunction	galago_presence_add_status
syn keyword galagoFunction	galago_presence_remove_status
syn keyword galagoFunction	galago_presence_clear_statuses
syn keyword galagoFunction	galago_presence_get_account
syn keyword galagoFunction	galago_presence_is_idle
syn keyword galagoFunction	galago_presence_get_idle_time
syn keyword galagoFunction	galago_presence_is_discarded
syn keyword galagoFunction	galago_presence_is_available
syn keyword galagoFunction	galago_presence_get_statuses
syn keyword galagoFunction	galago_presence_get_active_status
syn keyword galagoFunction	galago_presence_is_status_exclusive
syn keyword galagoFunction	galago_presence_get_status
syn keyword galagoFunction	galago_presence_has_status
syn keyword galagoFunction	galago_presence_has_status_type
syn keyword galagoFunction	galago_presence_compare

" galago-service.h
syn keyword galagoType		GalagoService
syn keyword galagoType		GalagoServiceClass
syn keyword galagoType		GalagoServiceFlags
syn keyword galagoType		GalagoServicePrivate
syn keyword galagoConstant	GALAGO_CLASS_SERVICE
syn keyword galagoConstant	GALAGO_DBUS_SERVICE_INTERFACE
syn keyword galagoConstant  GALAGO_PRESERVE_SPACES
syn keyword galagoConstant  GALAGO_PRESERVE_CASE
syn keyword galagoConstant  GALAGO_STRIP_SLASH
syn keyword galagoConstant	GALAGO_SERVICE_ID_AIM
syn keyword galagoConstant	GALAGO_SERVICE_ID_GADUGADU
syn keyword galagoConstant	GALAGO_SERVICE_ID_GROUPWISE
syn keyword galagoConstant	GALAGO_SERVICE_ID_ICQ
syn keyword galagoConstant	GALAGO_SERVICE_ID_IRC
syn keyword galagoConstant	GALAGO_SERVICE_ID_JABBER
syn keyword galagoConstant	GALAGO_SERVICE_ID_MSN
syn keyword galagoConstant	GALAGO_SERVICE_ID_NAPSTER
syn keyword galagoConstant	GALAGO_SERVICE_ID_SILC
syn keyword galagoConstant	GALAGO_SERVICE_ID_TREPIA
syn keyword galagoConstant	GALAGO_SERVICE_ID_YAHOO
syn keyword galagoConstant	GALAGO_SERVICE_ID_ZEPHYR
syn keyword galagoConstant	GALAGO_SERVICE_ID_ZEPHYR
syn keyword galagoMacro		GALAGO_IS_SERVICE
syn keyword galagoFunction	galago_service_get_class
syn keyword galagoFunction	galago_service_new
syn keyword galagoFunction	galago_service_get_id
syn keyword galagoFunction	galago_service_get_name
syn keyword galagoFunction	galago_service_is_native
syn keyword galagoFunction	galago_service_get_flags
syn keyword galagoFunction	galago_service_get_account
syn keyword galagoFunction	galago_service_get_accounts
syn keyword galagoFunction	galago_service_add_account
syn keyword galagoFunction	galago_service_remove_account
syn keyword galagoFunction	galago_service_normalize

" galago-signals.h
syn keyword galagoType		GalagoSignalHandler
syn keyword galagoType		GalagoSignalContext
syn keyword galagoType		GalagoMarshalFunc
syn keyword galagoMacro		GALAGO_SIGNAL_CONTEXT
syn keyword galagoFunction	galago_signal_context_new
syn keyword galagoFunction	galago_signal_context_destroy
syn keyword galagoFunction	galago_signal_context_freeze
syn keyword galagoFunction	galago_signal_context_thaw
syn keyword galagoFunction	galago_signal_context_is_frozen
syn keyword galagoFunction	galago_signal_context_find_handler
syn keyword galagoFunction	galago_signal_context_find_handler_with_id
syn keyword galagoFunction	galago_signal_register
syn keyword galagoFunction	galago_signal_unregister
syn keyword galagoFunction	galago_signal_connect_class
syn keyword galagoFunction	galago_signal_connect
syn keyword galagoFunction	galago_signals_disconnect_by_id
syn keyword galagoFunction	galago_signal_emit
syn keyword galagoFunction	galago_signal_emit_vargs
syn keyword galagoFunction	galago_signals_init
syn keyword galagoFunction	galago_signals_uninit

" galago-status.h
syn keyword galagoType		GalagoStatus
syn keyword galagoType		GalagoStatusClass
syn keyword galagoType		GalagoStatusPrivate
syn keyword galagoType		GalagoStatusAttr
syn keyword galagoType		GalagoStatusType
syn keyword galagoType		GalagoStatusAttrType
syn keyword galagoConstant	GALAGO_STATUS_UNSET
syn keyword galagoConstant	GALAGO_STATUS_OFFLINE
syn keyword galagoConstant	GALAGO_STATUS_AVAILABLE
syn keyword galagoConstant	GALAGO_STATUS_AWAY
syn keyword galagoConstant	GALAGO_STATUS_EXTENDED_AWAY
syn keyword galagoConstant	GALAGO_STATUS_HIDDEN
syn keyword galagoConstant	GALAGO_STATUS_ATTR_UNSET
syn keyword galagoConstant	GALAGO_STATUS_ATTR_BOOL
syn keyword galagoConstant	GALAGO_STATUS_ATTR_STRING
syn keyword galagoConstant	GALAGO_STATUS_ATTR_INT
syn keyword galagoConstant	GALAGO_STATUS_ATTR_DOUBLE
syn keyword galagoConstant	GALAGO_STATUS_ID_AVAILABLE
syn keyword galagoConstant	GALAGO_STATUS_ID_AWAY
syn keyword galagoConstant	GALAGO_STATUS_ID_BRB
syn keyword galagoConstant	GALAGO_STATUS_ID_BUSY
syn keyword galagoConstant	GALAGO_STATUS_ID_DND
syn keyword galagoConstant	GALAGO_STATUS_ID_EXTENDED_AWAY
syn keyword galagoConstant	GALAGO_STATUS_ID_HIDDEN
syn keyword galagoConstant	GALAGO_STATUS_ID_OFFLINE
syn keyword galagoConstant	GALAGO_CLASS_STATUS
syn keyword galagoMacro		GALAGO_IS_STATUS
syn keyword galagoFunction	galago_status_get_class
syn keyword galagoFunction	galago_status_new
syn keyword galagoFunction	galago_status_duplicate
syn keyword galagoFunction	galago_status_set_presence
syn keyword galagoFunction	galago_status_get_presence
syn keyword galagoFunction	galago_status_get_type
syn keyword galagoFunction	galago_status_get_id
syn keyword galagoFunction	galago_status_get_name
syn keyword galagoFunction	galago_status_is_exclusive
syn keyword galagoFunction	galago_status_is_available
syn keyword galagoFunction	galago_status_set_attr_bool
syn keyword galagoFunction	galago_status_set_attr_string
syn keyword galagoFunction	galago_status_set_attr_int
syn keyword galagoFunction	galago_status_set_attr_double
syn keyword galagoFunction	galago_status_remove_attr
syn keyword galagoFunction	galago_status_get_attr_bool
syn keyword galagoFunction	galago_status_get_attr_string
syn keyword galagoFunction	galago_status_get_attr_int
syn keyword galagoFunction	galago_status_get_attr_double
syn keyword galagoFunction	galago_status_attr_exists
syn keyword galagoFunction	galago_status_get_attributes
syn keyword galagoFunction	galago_status_attr_get_type
syn keyword galagoFunction	galago_status_attr_get_id
syn keyword galagoFunction	galago_status_attr_get_bool
syn keyword galagoFunction	galago_status_attr_get_string
syn keyword galagoFunction	galago_status_attr_get_int
syn keyword galagoFunction	galago_status_attr_get_double

" galago-types.h
syn keyword galagoType		galago_bool
syn keyword galagoType		GalagoForEachFunc
syn keyword galagoType		GalagoHForEachFunc
syn keyword galagoType		GalagoHashFunc
syn keyword galagoType		GalagoEqualFunc
syn keyword galagoType		GalagoFreeFunc
syn keyword galagoType		GalagoCallback
syn keyword galagoMacro		GALAGO_CALLBACK

" galago-utils.h
syn keyword galagoFunction	galago_str_lower
syn keyword galagoFunction	galago_str_upper
syn keyword galagoFunction	galago_malloc0
syn keyword galagoFunction	galago_memdup
syn keyword galagoMacro		galago_new
syn keyword galagoMacro		galago_new0

" galago-value.h
syn keyword galagoType		GalagoType
syn keyword galagoType		GalagoSubType
syn keyword galagoType		GalagoValue
syn keyword galagoConstant	GALAGO_TYPE_UNKNOWN
syn keyword galagoConstant	GALAGO_TYPE_CHAR
syn keyword galagoConstant	GALAGO_TYPE_UCHAR
syn keyword galagoConstant	GALAGO_TYPE_BOOLEAN
syn keyword galagoConstant	GALAGO_TYPE_SHORT
syn keyword galagoConstant	GALAGO_TYPE_USHORT
syn keyword galagoConstant	GALAGO_TYPE_INT
syn keyword galagoConstant	GALAGO_TYPE_UINT
syn keyword galagoConstant	GALAGO_TYPE_LONG
syn keyword galagoConstant	GALAGO_TYPE_ULONG
syn keyword galagoConstant	GALAGO_TYPE_STRING
syn keyword galagoConstant	GALAGO_TYPE_OBJECT
syn keyword galagoConstant	GALAGO_TYPE_POINTER
syn keyword galagoConstant	GALAGO_TYPE_LIST
syn keyword galagoConstant	GALAGO_TYPE_ARRAY
syn keyword galagoFunction	galago_value_new
syn keyword galagoFunction	galago_value_new_list
syn keyword galagoFunction	galago_value_new_array
syn keyword galagoFunction	galago_value_destroy
syn keyword galagoFunction	galago_value_get_type
syn keyword galagoFunction	galago_value_get_subtype
syn keyword galagoFunction	galago_value_get_object_class
syn keyword galagoFunction	galago_value_set_char
syn keyword galagoFunction	galago_value_set_uchar
syn keyword galagoFunction	galago_value_set_boolean
syn keyword galagoFunction	galago_value_set_short
syn keyword galagoFunction	galago_value_set_ushort
syn keyword galagoFunction	galago_value_set_int
syn keyword galagoFunction	galago_value_set_uint
syn keyword galagoFunction	galago_value_set_long
syn keyword galagoFunction	galago_value_set_ulong
syn keyword galagoFunction	galago_value_set_string
syn keyword galagoFunction	galago_value_set_object
syn keyword galagoFunction	galago_value_set_pointer
syn keyword galagoFunction	galago_value_set_list
syn keyword galagoFunction	galago_value_set_array
syn keyword galagoFunction	galago_value_get_char
syn keyword galagoFunction	galago_value_get_uchar
syn keyword galagoFunction	galago_value_get_boolean
syn keyword galagoFunction	galago_value_get_short
syn keyword galagoFunction	galago_value_get_ushort
syn keyword galagoFunction	galago_value_get_int
syn keyword galagoFunction	galago_value_get_uint
syn keyword galagoFunction	galago_value_get_long
syn keyword galagoFunction	galago_value_get_ulong
syn keyword galagoFunction	galago_value_get_string
syn keyword galagoFunction	galago_value_get_object
syn keyword galagoFunction	galago_value_get_pointer
syn keyword galagoFunction	galago_value_get_list
syn keyword galagoFunction	galago_value_get_array

" Default highlighting
if version >= 508 || !exists("did_galago_syntax_inits")
	if version < 508
		let did_galago_syntax_inits = 1
		command -nargs=+ HiLink hi link <args>
	else
		command -nargs=+ HiLink hi def link <args>
	endif

	HiLink galagoType		Type
	HiLink galagoFunction	Function
	HiLink galagoMacro		Macro
	HiLink galagoConstant	Constant
	delcommand HiLink
endif
