/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __GST_DSPFBSINK_H__
#define __GST_DSPFBSINK_H__

#include <sys/time.h>
#include <time.h>

/* For XOverlay */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <gst/gst.h>
#include <gst/video/gstvideosink.h>

#include <dspvideo.h>

G_BEGIN_DECLS


#define GST_TYPE_DSPFBSINK \
  (gst_dspfbsink_get_type())
#define GST_DSPFBSINK(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPFBSINK,GstDSPFBSink))
#define GST_DSPFBSINK_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPFBSINK,GstDSPFBSinkClass))
#define GST_IS_DSPFBSINK(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPFBSINK))
#define GST_IS_DSPFBSINK_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPFBSINK))


typedef struct _GstDSPFBSink GstDSPFBSink;
typedef struct _GstDSPFBSinkClass GstDSPFBSinkClass;

struct _GstDSPFBSink {
  GstVideoSink videosink;
  GstPad        *sinkpad;
  GstDSPVideo   *video;
  GstClock      *clock;

  GstClockTime   clocktime;
  struct timeval prevtime;

  guint          write_size;  // Size of the data to be written (in bytes)
  guint          mode;
  guint8         *mmap_buf_addr;

  gboolean        parsed;
  gboolean        paused;
  guint8          *outbuf;

  gdouble        qos_val;
  gboolean       qos_ok;

  // XOverlay
  char          *display_name;
  Window        win;
  Display       *disp;

  //Timestamp handling
  gboolean wait_pts;
  gint64 diff_pts;
  guint64 prev_gst_pts;
  guint64 avsync_pts;
  guint64 segment_start;

  gboolean first_discont;
  guint16 dsp_read_count;
  gboolean eos_mode;

  GstEvent *pending_seek;
  gboolean seeking;
  gboolean data_written;

//   gboolean dsp_request;
  gboolean avsync_clock_set;
 
  gint drop_count; 
  GQueue *buf_queue;
  guint qos_state;
};

struct _GstDSPFBSinkClass {
  GstVideoSinkClass parent_class;
};

GType gst_dspfbsink_get_type(void);
gboolean gst_dspfbsink_factory_init (GstElementFactory *factory);

G_END_DECLS

#endif /* __GST_DSPFBSINK_H__ */
