/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPILBCRC_H__
#define __GST_DSPILBCSRC_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstpushsrc.h>

#include <dspaudio.h>
#include <dsp/audio_dsptask.h>
#include <dsp/interface_common.h>

G_BEGIN_DECLS

#define GST_TYPE_DSPILBCSRC          (gst_dspilbcsrc_get_type())
#define GST_DSPILBCSRC(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPILBCSRC,GstDSPILBCSrc))
#define GST_DSPILBCSRC_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPILBCSRC,GstDSPILBCSrcClass))
#define GST_IS_DSPILBCSRC(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPILBCSRC))
#define GST_IS_DSPILBCSRC_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPILBCSRC))

typedef struct _GstDSPILBCSrc GstDSPILBCSrc;
typedef struct _GstDSPILBCSrcClass GstDSPILBCSrcClass;

typedef enum
{
  DSPILBC_PROP_MODE = DSPAUDIO_PROP_LAST,
  DSPILBC_PROP_DTX_MODE,
  DSPILBC_PROP_LAST
} DSPILBCProperties;

typedef enum {
  GST_ILBCSRC_MODE_20,
  GST_ILBCSRC_MODE_30,
} GstILBCSrcModes;

typedef enum {
  GST_ILBCSRC_DTX_MODE_OFF,
  GST_ILBCSRC_DTX_MODE_ON,
} GstILBCSrcDTXModes;


struct _GstDSPILBCSrc {
  GstPushSrc      parent;
  GstDSPAudio     *audio;
  guint           framesize;  // Size of one frame in bytes (38 or 50)
  guint64         framecount;
  guint           frametimemillis;

  GstILBCSrcModes    mode;
  GstILBCSrcDTXModes dtxmode;
};

struct _GstDSPILBCSrcClass {
  GstPushSrcClass parent_class;
};


GType gst_dspilbcsrc_get_type(void);

G_END_DECLS

#endif /* __GST_DSPILBCSRC_H__ */
