#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "omap.h"
#include "kdrive.h"

#include <fbdev.h>

typedef struct _kdInputFd {
    int    type;
    int    fd;
    void    (*read) (int fd, void *closure);
    int    (*enable) (int fd, void *closure);
    void    (*disable) (int fd, void *closure);
    void    *closure;
} KdInputFd;

    void
InitCard (char *name)
{   
    ENTER();
    KdCardAttr  attr;

    KdCardInfoAdd(&omapFuncs, &attr, 0);
    LEAVE();
}   

    void
InitOutput (ScreenInfo *pScreenInfo, int argc, char **argv)
{
    ENTER();
    KdInitOutput(pScreenInfo, argc, argv);
    LEAVE();
}   

    void
InitInput (int argc, char **argv)
{
#ifdef TOUCHSCREEN
    KdInitInput(&TsFuncs, &LinuxKeyboardFuncs);
#else
    KdInitInput(&LinuxMouseFuncs, &LinuxKeyboardFuncs);
#endif

#if 0
    /* find the console fd and use our own read function */
    KdBlockSigio();
    for (i=0; i < kdNumInputFds; i++) {
        kdInputFds[i]
#endif
    }
    void
        ddxUseMsg (void)
        {
            KdUseMsg();
        }

    int
        ddxProcessArgument (int argc, char **argv, int i)
        {
            return KdProcessArgument(argc, argv, i);
        }



