
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "omap.h"
#include "omapfb.h"

#include <X11/Xmd.h>

#include <linux/fb.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <errno.h>
#include <stdint.h>

#include "gcstruct.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "regionstr.h"
#include "mistruct.h"
#include "fontstruct.h"
#include "dixfontstr.h"
#include "fb.h"
#include "migc.h"
#include "miline.h"
#include "picturestr.h"
#include "kaa.h"
#include "damagestr.h"
#include "cursorstr.h"
#include "mipointrst.h"
#include "scrnintstr.h"

#include "miscstruct.h"
#include "region.h"
#include "mi.h"
#include "windowstr.h"
#include "mivalidate.h"

#include "spext.h"
#include <X11/extensions/xspproto.h>
#include <X11/extensions/xspwire.h>

#define RESET_ODB() \
    omaps->odb.x1 = 29999; \
omaps->odb.y1 = 29999; \
omaps->odb.x2 = -29999; \
omaps->odb.y2 = -29999



static void omapInternalDamageReport(OmapScreenInfo *omaps, 
        OmapDamageBoxPtr od, int x1, int y1, int x2, int y2);

void omapFlushDamage(void);

void omapRestoreAreas(PixmapPtr	pPixmap,
        RegionPtr	prgn,
        int		xorg,
        int		yorg,
        WindowPtr	pWindow);
void omapSetWindowPixmap(WindowPtr pWindow, PixmapPtr pPixmap);
Bool omapDestroyWindow(WindowPtr pWindow);
Bool omapCloseScreen(int i, ScreenPtr pScreen);

Bool omapDestroyPixmap(PixmapPtr pPixmap);
void omapPaintWindow(WindowPtr pWindow,
        RegionPtr prgn,
        int	    what);
void omapCopyWindow(WindowPtr	pWindow,
        DDXPointRec	ptOldOrg,
        RegionPtr	prgnSrc);

#ifdef RENDER
void omapComposite(CARD8      op,
        PicturePtr pSrc,
        PicturePtr pMask,
        PicturePtr pDst,
        INT16      xSrc,
        INT16      ySrc,
        INT16      xMask,
        INT16      yMask,
        INT16      xDst,
        INT16      yDst,
        CARD16     width,
        CARD16     height);
void omapGlyphs(CARD8		op,
        PicturePtr	pSrc,
        PicturePtr	pDst,
        PictFormatPtr	maskFormat,
        INT16		xSrc,
        INT16		ySrc,
        int		nlist,
        GlyphListPtr	list,
        GlyphPtr	*glyphs);

#endif

OmapScreenInfo *accel_omaps;
CARD32 color;
CARD32 rop;

union {
    struct fb_fillrect      rect;
    struct fb_copyarea      area;
    struct fb_image         image;
    struct fb_scale         scale;
    struct fb_frame_offset  frame_offset;
    struct fb_update_window	window;
    unsigned int            frame_idx;
    unsigned int            mirror;
} fb_p;



static void setcolors(int fb_fd, unsigned int fgcolor, unsigned int bgcolor)
{
    unsigned short red[2], green[2], blue[2];
    struct fb_cmap cmap;

    red[0] = ( (bgcolor >> 11) & 0x3f ) << 11;
    red[1] = ( (fgcolor >> 11) & 0x3f ) << 11;
    green[0] = ( (bgcolor >> 6) & 0x7f ) << 10;
    green[1] = ( (fgcolor >> 6) & 0x7f ) << 10;
    blue[0] = ( bgcolor & 0x3f ) << 11;
    blue[1] = ( fgcolor & 0x3f ) << 11;
    cmap.start = 0;
    cmap.len = 2;
    cmap.red = red;
    cmap.green = green;
    cmap.blue = blue;
    cmap.transp = NULL;

    if (ioctl(fb_fd, FBIOPUTCMAP, &cmap) < 0) {
        perror("ioctl FBIOPUTCMAP");
    }
}


static Bool omapPrepareSolid(PixmapPtr pPixmap, int alu, Pixel pm, Pixel fg)
{
    KdScreenPriv(pPixmap->drawable.pScreen);
    omapScreenInfo(pScreenPriv);

    return FALSE;

    if (pm != -1) {
        return FALSE;
    }
    accel_omaps = omaps;

    color = fg;

    switch (alu) {
        case 0x3:
            rop = ROP_COPY;
            break;
        default:
            return FALSE;
            break;
    }

    return TRUE;
}

static void omapSolid(int x1, int y1, int x2, int y2)
{
    fb_p.rect.dx = x1;
    fb_p.rect.dy = y1;
    fb_p.rect.width = x2-x1;
    fb_p.rect.height = y2-y1;

    setcolors(accel_omaps->omapc->backend_priv.fbdev.fd, color, 0);
    fb_p.rect.color = 1;
    fb_p.rect.rop = rop;

    if (ioctl(accel_omaps->omapc->backend_priv.fbdev.fd,
                OMAPFB_FILLRECT,&fb_p.rect) < 0) {
        perror("omapSolid");
    }
}

static void omapDoneSolid(void)
{
    //ioctl(accel_omaps->omapc->backend_priv.fbdev.fd, OMAPFB_SYNC_GFX);
}

static Bool omapPrepareCopy(PixmapPtr pSrcPixmap,
        PixmapPtr pDestPixmap,
        int dx, int dy, int alu, Pixel pm)
{
    KdScreenPriv(pDestPixmap->drawable.pScreen);
    omapScreenInfo(pScreenPriv);

    return FALSE;

    if (pm != -1) {
        return FALSE;
    }

    accel_omaps = omaps;

    switch (alu) {
        case 0x3:
            rop = ROP_COPY;
            break;
        default:
            return FALSE;
            break;

    }

    return TRUE;
}


static void omapCopy(int srcX, int srcY, int dstX, int dstY, int w, int h)
{
    fb_p.area.dx = dstX;
    fb_p.area.dy = dstY;
    fb_p.area.width = w;
    fb_p.area.height = h;
    fb_p.area.sx = srcX;
    fb_p.area.sy = srcY;

    if (ioctl(accel_omaps->omapc->backend_priv.fbdev.fd,
                OMAPFB_COPYAREA,&fb_p.area) < 0) {
        perror("omapCopy");
    }
}



static void omapDoneCopy(void)
{
    //ioctl(accel_omaps->omapc->backend_priv.fbdev.fd, OMAPFB_SYNC_GFX);
}



static void omapUpdateTornado(OmapScreenInfo *omaps)
{
    xspScrPrivPtr pScrPriv;

    if (omaps->odb.x1 > omaps->screen->width 
            || omaps->odb.y1 > omaps->screen->height)
        goto getout;

    if (omaps->odb.x2 > omaps->screen->width) omaps->odb.x2 = omaps->screen->width;
    if (omaps->odb.y2 > omaps->screen->height) omaps->odb.y2 = omaps->screen->height;
    if (omaps->odb.x1 < 0) omaps->odb.x1 = 0;
    if (omaps->odb.y1 < 0) omaps->odb.y1 = 0;

    fb_p.window.width = omaps->odb.x2 - omaps->odb.x1;
    fb_p.window.height = omaps->odb.y2 - omaps->odb.y1;
   

    if (fb_p.window.width <= 0 || fb_p.window.height <= 0) goto getout;

    if (xspScrPrivateIndex > 0) {
        pScrPriv = omaps->screen->pScreen->devPrivates[xspScrPrivateIndex].ptr;
    } else {
        pScrPriv = NULL;
    }

    if (pScrPriv && pScrPriv->pixel_doubling) {
        fb_p.window.format = FB_COLOR_RGB565 | FB_FORMAT_FLAG_DOUBLE;
    } else {
        fb_p.window.format = FB_COLOR_RGB565;
    }
    
    fb_p.window.x = omaps->odb.x1;
    fb_p.window.y = omaps->odb.y1;

    if (ioctl(omaps->omapc->backend_priv.fbdev.fd,OMAPFB_UPDATE_WINDOW,&fb_p.window) < 0) {
        /* this would fail if the tornado update mode has been set
         * to either FB_AUTO_UPDATE or FB_UPDATE_DISABLED
         * dsme might do that, so if we fail, we just ignore
         * and hope that the system is not totally hosed.
         * */

        /* DBGOUT("box: (%i,%i) %ix%i\n", fb_p.window.x, fb_p.window.y, fb_p.window.width, fb_p.window.height); */
    }

getout:
    RESET_ODB(); // reset the coordinates
}

void omapTornadoUpdatePump(int force)
{
    int i;

    if (!force) {
        OmapDamageBox od;
        i = screenInfo.numScreens;
        while (i--) {
            KdScreenPriv(screenInfo.screens[i]);
            omapScreenInfo(pScreenPriv);

            od.box.x1 = omaps->odb.x1;
            od.box.y1 = omaps->odb.y1;
            od.box.x2 = omaps->odb.x2;
            od.box.y2 = omaps->odb.y2;
            od.omaps = omaps;
            omapSendDamage(&od);
        }
    } else {
        i = screenInfo.numScreens;
        while (i--) {
            KdScreenPriv(screenInfo.screens[i]);
            omapScreenInfo(pScreenPriv);

            omapUpdateTornado(omaps);
        }
    }
}

static inline int checkSending(uint64_t last_update, uint64_t curr)
{
    if (curr < last_update) return 1;
    if (curr - last_update > OMAP_DMG_ACCTIME) return 1;
    return 0;
}

void omapSendDamage(OmapDamageBoxPtr od)
{
    struct timeval t;
    uint64_t curr;
    xspScrPrivPtr pScrPriv;

    // accumulate the damage area
    if (!od) return;

    if (od->omaps->odb.x1 > od->box.x1) od->omaps->odb.x1 = od->box.x1;
    if (od->omaps->odb.y1 > od->box.y1) od->omaps->odb.y1 = od->box.y1;
    if (od->omaps->odb.x2 < od->box.x2) od->omaps->odb.x2 = od->box.x2;
    if (od->omaps->odb.y2 < od->box.y2) od->omaps->odb.y2 = od->box.y2;


    /*
     * no accumulation if dsp is drawing the video
     * */

    if (xspScrPrivateIndex > 0) {
        pScrPriv = od->omaps->screen->pScreen->devPrivates[xspScrPrivateIndex].ptr;
    } else {
        pScrPriv = NULL;
    }

    if (pScrPriv && pScrPriv->dsp_enabled) {
        omapUpdateTornado(od->omaps);
        return;
    }


    // check if we should indeed send the accumulated damage box
    if (gettimeofday(&t, NULL) < 0) {
        // send anyway
        omapUpdateTornado(od->omaps);
    } else {
        curr = t.tv_sec * 1000000 + t.tv_usec;
        if (checkSending(od->omaps->last_update, curr)) {
            // send
            omapUpdateTornado(od->omaps);
            od->omaps->last_update = curr;
        }
    }
}

static void omapInternalDamageReport(OmapScreenInfo *omaps,
        OmapDamageBoxPtr od,
        int x1, int y1, int x2, int y2)
{
    xspScrPrivPtr pScrPriv;

    int i;
    memset(od,'\0',sizeof(OmapDamageBox));
    od->omaps = omaps;
    od->id = omaps->damage_id_index++;

    /* now force the coordinates to sit within the screen area */

    if (x1 > x2) { i = x2; x2 = x1; x1 = i; }
    if (y1 > y2) { i = y2; y2 = y1; y1 = i; }

    if (x1 < 0) {
        od->box.x1 = 0;
    } else if (x1 > omaps->screen->width) {
        return ; // nothing to do
    } else {
        od->box.x1 = x1;
    }

    if (y1 < 0) {
        od->box.y1 = 0;
    } else if (y1 > omaps->screen->height) {
        return ; // nothing to do
    } else {
        od->box.y1 = y1;
    }

    if (x2 > omaps->screen->width) {
        od->box.x2 = omaps->screen->width;
    } else if (x2 < 0) {
        od->box.x2 = 0;
    } else {
        od->box.x2 = x2;
    }

    if (y2 > omaps->screen->height) {
        od->box.y2 = omaps->screen->height;
    } else if (y2 < 0) {
        od->box.y2 = 0;
    } else {
        od->box.y2 = y2;
    }

    if (xspScrPrivateIndex > 0) {
        pScrPriv = omaps->screen->pScreen->devPrivates[xspScrPrivateIndex].ptr;
    } else {
        pScrPriv = NULL;
    }

    if (pScrPriv && pScrPriv->dsp_enabled) {
        /* dsp area has been registered */
        /* check for overlap */
        //fprintf(stderr,"dsp_box: (%i,%i) x (%i,%i)\nupdate box: (%i,%i) x (%i,%i)\n",pScrPriv->dsp_box.x1, pScrPriv->dsp_box.y1, pScrPriv->dsp_box.x2, pScrPriv->dsp_box.y2, od->box.x1, od->box.y1, od->box.x2, od->box.y2);
        if ( !( (pScrPriv->dsp_box.x2 <= od->box.x1) ||
                    (pScrPriv->dsp_box.x1 >= od->box.x2) ||
                    (pScrPriv->dsp_box.y2 <= od->box.y1) ||
                    (pScrPriv->dsp_box.y1 >= od->box.y2) ) ) {

            /* they overlap, stop DSP before continuing */
            int dsp_ctl_fd;
            xXSPDSPStoppedEvent ev;
            ev.type = XSPEventBase + X_XSPDSPStopped;
            ev.sequenceNumber = pScrPriv->dsp_client->sequence;
            fprintf(stderr, "Xomap: Stopping DSP...\n");

            if ( (dsp_ctl_fd = open("/dev/dspctl/ctl", O_RDWR)) < 0) {
                perror("Xomap: Unable to open /dev/dspctl/ctl to stop DSP\n");
            } else {
                if (ioctl(dsp_ctl_fd, OMAP_DSP_IOCTL_FBDIS) < 0) {
                    perror("Xomap: ioctl OMAP_DSP_IOCTL_FBDIS failed");
                }
                close(dsp_ctl_fd);
            }

            if (!pScrPriv->dsp_client->clientGone) {
                WriteEventsToClient(pScrPriv->dsp_client,1,(xEvent *)&ev);
            }

            pScrPriv->dsp_enabled = 0;
            pScrPriv->dsp_client = NULL;
            pScrPriv->dsp_box.x1 = 29999;
            pScrPriv->dsp_box.y1 = 29999;
            pScrPriv->dsp_box.x2 = -29999;
            pScrPriv->dsp_box.y2 = -29999;

        }
    }
}

static void omapBlockHandler(pointer blockData, OSTimePtr timeout, pointer readmask)
{
    /* flush all remaining tornado updates */
    omapTornadoUpdatePump(1);
}

static void omapWakeupHandler(pointer blockData, int result, pointer readmask)
{
}

int omapGCPrivateIndex;
int omapGeneration;

Bool omapDrawInit(ScreenPtr pScreen)
{
    ENTER();
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);

    if (omapGeneration != serverGeneration)
    {
        omapGCPrivateIndex = AllocateGCPrivateIndex ();
        if (omapGCPrivateIndex == -1)
            return FALSE;
        omapGeneration = serverGeneration;
    }

    memset(&omaps->kaa, 0, sizeof(KaaScreenInfoRec));
    omaps->kaa.PrepareSolid = omapPrepareSolid;
    omaps->kaa.Solid = omapSolid;
    omaps->kaa.DoneSolid = omapDoneSolid;
    omaps->kaa.PrepareCopy = omapPrepareCopy;
    omaps->kaa.Copy = omapCopy;
    omaps->kaa.DoneCopy = omapDoneCopy;

    omaps->kaa.flags = KAA_OFFSCREEN_PIXMAPS;

    omaps->kaa.PrepareBlend = NULL;
    omaps->kaa.Blend = NULL;
    omaps->kaa.DoneBlend = NULL;
    omaps->kaa.CheckComposite = NULL;
    omaps->kaa.PrepareComposite = NULL;
    omaps->kaa.Composite = NULL;
    omaps->kaa.DoneComposite = NULL;

    omaps->kaa.PrepareTrapezoids = NULL;
    omaps->kaa.Trapezoids = NULL;
    omaps->kaa.DoneTrapezoids = NULL;

    omaps->kaa.UploadToScreen = NULL;
    omaps->kaa.UploadToScratch = NULL;

    accel_omaps = omaps;

    if (!AllocateGCPrivate (pScreen, omapGCPrivateIndex, sizeof (OmapGCPrivRec)))
        return FALSE;

    if (!kaaDrawInit(pScreen, &omaps->kaa)) {
        return FALSE;
    }
    RegisterBlockAndWakeupHandlers(omapBlockHandler, omapWakeupHandler, pScreen);
    LEAVE();
    return TRUE;
}

void omapDrawEnable(ScreenPtr pScreen)
{
#ifdef RENDER
    PictureScreenPtr ps = GetPictureScreenIfSet(pScreen);
#endif
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    miPointerScreenPtr mi_pScreenPriv;
    ENTER();
    mi_pScreenPriv = (miPointerScreenPtr)pScreen->devPrivates[miPointerScreenIndex].ptr;

    wrap (omaps, pScreen, DestroyPixmap, omapDestroyPixmap);
    wrap (omaps, pScreen, CreateGC, omapCreateGC);
    wrap (omaps, pScreen, PaintWindowBackground, omapPaintWindow);
    wrap (omaps, pScreen, PaintWindowBorder, omapPaintWindow);
    wrap (omaps, pScreen, DestroyWindow, omapDestroyWindow);
    wrap (omaps, pScreen, SetWindowPixmap, omapSetWindowPixmap);
    wrap (omaps, pScreen, CopyWindow, omapCopyWindow);
    wrap (omaps, pScreen, CloseScreen, omapCloseScreen);
    wrap (omaps, pScreen, BackingStoreFuncs.RestoreAreas, omapRestoreAreas);

#ifdef RENDER
    if (ps) {
        wrap (omaps, ps, Glyphs, omapGlyphs);
        wrap (omaps, ps, Composite, omapComposite);
    }
#endif

    RESET_ODB(); // initialize the update rectangle
    KdMarkSync(pScreen);
    LEAVE();
}

void omapDrawDisable(ScreenPtr pScreen)
{
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
#ifdef RENDER
    PictureScreenPtr ps = GetPictureScreenIfSet(pScreen);
#endif

    ENTER();
    unwrap (omaps, pScreen, DestroyPixmap);
    unwrap (omaps, pScreen, CreateGC);
    unwrap (omaps, pScreen, PaintWindowBackground);
    unwrap (omaps, pScreen, PaintWindowBorder);
    unwrap (omaps, pScreen, DestroyWindow);
    unwrap (omaps, pScreen, SetWindowPixmap);
    unwrap (omaps, pScreen, CopyWindow);
    unwrap (omaps, pScreen, CloseScreen);
    unwrap (omaps, pScreen, BackingStoreFuncs.RestoreAreas);

#ifdef RENDER
    if (ps) {
        unwrap (omaps, ps, Glyphs);
        unwrap (omaps, ps, Composite);
    }
#endif
    LEAVE();
}

void omapDrawFini(ScreenPtr pScreen)
{
    ENTER();
    accel_omaps = NULL;
    RemoveBlockAndWakeupHandlers(omapBlockHandler, omapWakeupHandler, pScreen);
    kaaDrawFini(pScreen);
    LEAVE();
}

void omapDrawSync(ScreenPtr pScreen)
{
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    //	ENTER();
    ioctl(omaps->omapc->backend_priv.fbdev.fd, OMAPFB_SYNC_GFX);
    //	LEAVE();
}


PixmapPtr omapGetDrawablePixmap(DrawablePtr pDrawable)
{
    ScreenPtr	pScreen = pDrawable->pScreen;
    PixmapPtr	pPixmap;
    if (pDrawable->type == DRAWABLE_WINDOW) {
        pPixmap = (*pScreen->GetWindowPixmap) ((WindowPtr) pDrawable);
        if (!pPixmap) {
            pPixmap = (*pScreen->GetScreenPixmap) (pDrawable->pScreen);
        }
    }
    else {
        pPixmap = (PixmapPtr) pDrawable;
    }
    return pPixmap;
}

#ifdef DEBUG_ODB
OmapDamageRegionPtr _omapDamageRegion(char *func, DrawablePtr pDrawable, RegionPtr pRegion, Bool clip)
#else
OmapDamageRegionPtr omapDamageRegion(DrawablePtr pDrawable, RegionPtr pRegion, Bool clip)
#endif
{
    int           nbox;
    BoxPtr        pbox;
    OmapDamageRegionPtr odr;
    OmapDamageBoxPtr odb;

    KdScreenPriv(pDrawable->pScreen);
    omapScreenInfo(pScreenPriv);


#ifdef DEBUG_ODB
    fprintf(stderr, "[ODBDEBUG] omapDamageRegion called from %s\n",func);
#endif

    if (pDrawable->type != DRAWABLE_WINDOW)
        return NULL;

    if ((odr = xalloc(sizeof(OmapDamageRegion))) == NULL) return NULL;

    nbox = REGION_NUM_RECTS(pRegion);
    pbox = REGION_RECTS(pRegion);

    odr->count = nbox;
    if ((odr->box = (OmapDamageBoxPtr)xalloc(sizeof(OmapDamageBox) * nbox)) == NULL) {
        xfree(odr);
        return NULL;
    }
    odb = odr->box;

    while (nbox--) {
        //fprintf(stderr, "Looping... %d,%d,%d,%d\n", pbox->x1, pbox->y1, pbox->x2, pbox->y2);
        omapInternalDamageReport(omaps, odb, pbox->x1, pbox->y1, pbox->x2, pbox->y2);
        odb++;
        pbox++;
    }
    return odr;
}

#ifdef DEBUG_ODB
OmapDamageBoxPtr _omapDamageBox(char *func,DrawablePtr pDrawable, BoxPtr pBox)
#else
OmapDamageBoxPtr omapDamageBox(DrawablePtr pDrawable, BoxPtr pBox)
#endif
{
    OmapDamageBoxPtr od;
    KdScreenPriv(pDrawable->pScreen);
    omapScreenInfo(pScreenPriv);

#ifdef DEBUG_ODB
    fprintf(stderr, "[ODBDEBUG] omapDamageBox called from %s\n",func);
#endif
    if (pDrawable->type != DRAWABLE_WINDOW)
        return NULL;

    if ((od = (OmapDamageBoxPtr)xalloc(sizeof(OmapDamageBox))) == NULL) return NULL;
    //fprintf(stderr, "NOT Looping: %d,%d,%d,%d\n", pBox->x1, pBox->y1, pBox->x2, pBox->y2);
    omapInternalDamageReport(omaps, od, pBox->x1, pBox->y1, pBox->x2, pBox->y2);
    return od;
}


/* wrapped screen functions */

void omapRestoreAreas(PixmapPtr	pPixmap,
        RegionPtr	prgn,
        int		xorg,
        int		yorg,
        WindowPtr	pWindow)
{
    ScreenPtr pScreen = pWindow->drawable.pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    OmapDamageBoxPtr odl;
    OmapDamageRegionPtr odr = omapDamageRegion (&pWindow->drawable, prgn, FALSE);
    int odc;

    unwrap (omaps, pScreen, BackingStoreFuncs.RestoreAreas);
    (*pScreen->BackingStoreFuncs.RestoreAreas) (pPixmap, prgn,
                                                xorg, yorg, pWindow);
    wrap(omaps, pScreen, BackingStoreFuncs.RestoreAreas,
            omapRestoreAreas);
    if (odr) {
        odc = odr->count;
        odl = odr->box;
        while (odc--) {
            omapSendDamage(odl++);
        }
        xfree(odr->box);
        xfree(odr);
    }
}

void omapSetWindowPixmap(WindowPtr pWindow, PixmapPtr pPixmap)
{
    ScreenPtr pScreen = pWindow->drawable.pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);

    unwrap(omaps, pScreen, SetWindowPixmap);
    (*pScreen->SetWindowPixmap) (pWindow, pPixmap);
    wrap(omaps, pScreen, SetWindowPixmap, omapSetWindowPixmap);
}

Bool omapDestroyWindow(WindowPtr pWindow)
{
    ScreenPtr pScreen = pWindow->drawable.pScreen;
    Bool ret;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);

    unwrap(omaps, pScreen, DestroyWindow);
    ret = (*pScreen->DestroyWindow) (pWindow);
    wrap(omaps, pScreen, DestroyWindow, omapDestroyWindow);
    return ret;
}

Bool omapCloseScreen(int i, ScreenPtr pScreen)
{
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);

    unwrap(omaps, pScreen, DestroyPixmap);
    unwrap(omaps, pScreen, CreateGC);
    unwrap(omaps, pScreen, PaintWindowBackground);
    unwrap(omaps, pScreen, PaintWindowBorder);
    unwrap(omaps, pScreen, CopyWindow);
    unwrap(omaps, pScreen, CloseScreen);
    unwrap(omaps, pScreen, BackingStoreFuncs.RestoreAreas);

    return (*pScreen->CloseScreen) (i, pScreen);
}

Bool omapDestroyPixmap(PixmapPtr pPixmap)
{
    ScreenPtr pScreen = pPixmap->drawable.pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);

    unwrap(omaps, pScreen, DestroyPixmap);
    (*pScreen->DestroyPixmap) (pPixmap);
    wrap(omaps, pScreen, DestroyPixmap, omapDestroyPixmap);
    return TRUE;
}

void omapPaintWindow(WindowPtr pWindow,
        RegionPtr prgn,
        int	    what)
{
    ScreenPtr pScreen = pWindow->drawable.pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    OmapDamageRegionPtr odr = NULL;
    OmapDamageBoxPtr odl;
    int odc;

    /*
     * Painting background none doesn't actually *do* anything, so
     * no damage is recorded
     */
    if ((what != PW_BACKGROUND || pWindow->backgroundState != None))
        odr = omapDamageRegion(&pWindow->drawable, prgn, FALSE);
    if(what == PW_BACKGROUND) {
        unwrap(omaps, pScreen, PaintWindowBackground);
        (*pScreen->PaintWindowBackground) (pWindow, prgn, what);
        wrap(omaps, pScreen, PaintWindowBackground, omapPaintWindow);
    } else {
        unwrap(omaps, pScreen, PaintWindowBorder);
        (*pScreen->PaintWindowBorder) (pWindow, prgn, what);
        wrap (omaps, pScreen, PaintWindowBorder, omapPaintWindow);
    }
    if (odr) {
        odc = odr->count;
        odl = odr->box;
        while (odc--) {
            omapSendDamage(odl++);
        }
        xfree(odr->box);
        xfree(odr);
    }
}


void omapCopyWindow(WindowPtr	pWindow,
        DDXPointRec	ptOldOrg,
        RegionPtr	prgnSrc)
{
    ScreenPtr pScreen = pWindow->drawable.pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    OmapDamageBoxPtr odl;
    OmapDamageRegionPtr odr = NULL;
    int odc;

    int dx = pWindow->drawable.x - ptOldOrg.x;
    int dy = pWindow->drawable.y - ptOldOrg.y;

    /*
     * The region comes in source relative, but the damage occurs
     * at the destination location.  Translate back and forth.
     */
    REGION_TRANSLATE (pScreen, prgnSrc, dx, dy);
    odr = omapDamageRegion (&pWindow->drawable, prgnSrc, FALSE);
    REGION_TRANSLATE (pScreen, prgnSrc, -dx, -dy);

    unwrap(omaps, pScreen, CopyWindow);
    (*pScreen->CopyWindow) (pWindow, ptOldOrg, prgnSrc);
    wrap(omaps, pScreen, CopyWindow, omapCopyWindow);
    if (odr) {
        odc = odr->count;
        odl = odr->box;
        while (odc--) {
            omapSendDamage(odl++);
        }
        xfree(odr->box);
        xfree(odr);
    }
}

/* wrapped RENDER functions */

#ifdef RENDER

#define TRIM_PICTURE_BOX(box, pDst) { \
    BoxPtr extents = &pDst->pCompositeClip->extents;\
    if(box.x1 < extents->x1) box.x1 = extents->x1; \
    if(box.x2 > extents->x2) box.x2 = extents->x2; \
    if(box.y1 < extents->y1) box.y1 = extents->y1; \
    if(box.y2 > extents->y2) box.y2 = extents->y2; \
}

void omapComposite(CARD8      op,
        PicturePtr pSrc,
        PicturePtr pMask,
        PicturePtr pDst,
        INT16      xSrc,
        INT16      ySrc,
        INT16      xMask,
        INT16      yMask,
        INT16      xDst,
        INT16      yDst,
        CARD16     width,
        CARD16     height)
{
    ScreenPtr		pScreen = pDst->pDrawable->pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    PictureScreenPtr	ps = GetPictureScreen(pScreen);
    OmapDamageBoxPtr od = NULL;

    BoxRec	box;

    box.x1 = xDst + pDst->pDrawable->x;
    box.y1 = yDst + pDst->pDrawable->y;
    box.x2 = box.x1 + width;
    box.y2 = box.y1 + height;
    TRIM_PICTURE_BOX(box, pDst);
    if (BOX_NOT_EMPTY(box))
        od = omapDamageBox (pDst->pDrawable, &box);

    unwrap(omaps, ps, Composite);
    (*ps->Composite) (op,
                      pSrc,
                      pMask,
                      pDst,
                      xSrc,
                      ySrc,
                      xMask,
                      yMask,
                      xDst,
                      yDst,
                      width,
                      height);
    if (od) {
        omapSendDamage(od);
        xfree(od);
    }
    wrap(omaps, ps, Composite, omapComposite);
}

void omapGlyphs(CARD8		op,
        PicturePtr	pSrc,
        PicturePtr	pDst,
        PictFormatPtr	maskFormat,
        INT16		xSrc,
        INT16		ySrc,
        int		nlist,
        GlyphListPtr	list,
        GlyphPtr	*glyphs)
{
    ScreenPtr		pScreen = pDst->pDrawable->pScreen;
    KdScreenPriv(pScreen);
    omapScreenInfo(pScreenPriv);
    PictureScreenPtr	ps = GetPictureScreen(pScreen);
    OmapDamageBoxPtr od = NULL;

    int		nlistTmp = nlist;
    GlyphListPtr	listTmp = list;
    GlyphPtr	*glyphsTmp = glyphs;
    int		x, y;
    int		n;
    GlyphPtr	glyph;
    BoxRec		box;
    int		x1, y1, x2, y2;

    box.x1 = 32767;
    box.y1 = 32767;
    box.x2 = -32767;
    box.y2 = -32767;
    x = pDst->pDrawable->x;
    y = pDst->pDrawable->y;
    while (nlistTmp--)
    {
        x += listTmp->xOff;
        y += listTmp->yOff;
        n = listTmp->len;
        while (n--)
        {
            glyph = *glyphsTmp++;
            x1 = x - glyph->info.x;
            y1 = y - glyph->info.y;
            x2 = x1 + glyph->info.width;
            y2 = y1 + glyph->info.height;
            if (x1 < box.x1)
                box.x1 = x1;
            if (y1 < box.y1)
                box.y1 = y1;
            if (x2 > box.x2)
                box.x2 = x2;
            if (y2 > box.y2)
                box.y2 = y2;
            x += glyph->info.xOff;
            y += glyph->info.yOff;
        }
        listTmp++;
    }
    TRIM_PICTURE_BOX (box, pDst);
    if (BOX_NOT_EMPTY(box))
        od = omapDamageBox (pDst->pDrawable, &box);

    unwrap(omaps, ps, Glyphs);
    (*ps->Glyphs) (op, pSrc, pDst, maskFormat, xSrc, ySrc, nlist, list, glyphs);
    if (od) {
        omapSendDamage(od);
        xfree(od);
    }
    wrap(omaps, ps, Glyphs, omapGlyphs);
}
#endif
